/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineElementType;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.Collection;
import java.util.Map;

public final class DisambiguateTypeAnnotations {
    public static SourceTypeBoundClass bind(SourceTypeBoundClass base, Env<ClassSymbol, TypeBoundClass> env) {
        return new SourceTypeBoundClass(base.interfaceTypes(), base.permits(), base.superClassType(), base.typeParameterTypes(), base.access(), DisambiguateTypeAnnotations.bindComponents(env, base.components(), TurbineElementType.RECORD_COMPONENT), DisambiguateTypeAnnotations.bindMethods(env, base.methods()), DisambiguateTypeAnnotations.bindFields(env, base.fields()), base.owner(), base.kind(), base.children(), base.typeParameters(), base.enclosingScope(), base.scope(), base.memberImports(), base.annotationMetadata(), DisambiguateTypeAnnotations.groupRepeated(env, base.annotations()), base.source(), base.decl());
    }

    private static ImmutableList<TypeBoundClass.MethodInfo> bindMethods(Env<ClassSymbol, TypeBoundClass> env, ImmutableList<TypeBoundClass.MethodInfo> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.MethodInfo field : fields) {
            result.add((Object)DisambiguateTypeAnnotations.bindMethod(env, field));
        }
        return result.build();
    }

    private static TypeBoundClass.MethodInfo bindMethod(Env<ClassSymbol, TypeBoundClass> env, TypeBoundClass.MethodInfo base) {
        ImmutableList.Builder declarationAnnotations = ImmutableList.builder();
        Type returnType = DisambiguateTypeAnnotations.disambiguate(env, base.name().equals("<init>") ? TurbineElementType.CONSTRUCTOR : TurbineElementType.METHOD, base.returnType(), base.annotations(), (ImmutableList.Builder<AnnoInfo>)declarationAnnotations);
        return new TypeBoundClass.MethodInfo(base.sym(), base.tyParams(), returnType, DisambiguateTypeAnnotations.bindParameters(env, base.parameters(), TurbineElementType.PARAMETER), base.exceptions(), base.access(), base.defaultValue(), base.decl(), (ImmutableList<AnnoInfo>)declarationAnnotations.build(), base.receiver() != null ? DisambiguateTypeAnnotations.bindParam(env, base.receiver(), TurbineElementType.PARAMETER) : null);
    }

    private static ImmutableList<TypeBoundClass.ParamInfo> bindParameters(Env<ClassSymbol, TypeBoundClass> env, ImmutableList<TypeBoundClass.ParamInfo> params, TurbineElementType declarationTarget) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.ParamInfo param : params) {
            result.add((Object)DisambiguateTypeAnnotations.bindParam(env, param, declarationTarget));
        }
        return result.build();
    }

    private static TypeBoundClass.ParamInfo bindParam(Env<ClassSymbol, TypeBoundClass> env, TypeBoundClass.ParamInfo base, TurbineElementType declarationTarget) {
        ImmutableList.Builder declarationAnnotations = ImmutableList.builder();
        Type type = DisambiguateTypeAnnotations.disambiguate(env, declarationTarget, base.type(), base.annotations(), (ImmutableList.Builder<AnnoInfo>)declarationAnnotations);
        return new TypeBoundClass.ParamInfo(base.sym(), type, (ImmutableList<AnnoInfo>)declarationAnnotations.build(), base.access());
    }

    private static ImmutableList<TypeBoundClass.RecordComponentInfo> bindComponents(Env<ClassSymbol, TypeBoundClass> env, ImmutableList<TypeBoundClass.RecordComponentInfo> components, TurbineElementType declarationTarget) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.RecordComponentInfo component : components) {
            ImmutableList.Builder declarationAnnotations = ImmutableList.builder();
            Type type = DisambiguateTypeAnnotations.disambiguate(env, declarationTarget, component.type(), component.annotations(), (ImmutableList.Builder<AnnoInfo>)declarationAnnotations);
            result.add((Object)new TypeBoundClass.RecordComponentInfo(component.sym(), type, (ImmutableList<AnnoInfo>)declarationAnnotations.build(), component.access()));
        }
        return result.build();
    }

    private static Type disambiguate(Env<ClassSymbol, TypeBoundClass> env, TurbineElementType declarationTarget, Type type, ImmutableList<AnnoInfo> annotations, ImmutableList.Builder<AnnoInfo> declarationAnnotations) {
        annotations = DisambiguateTypeAnnotations.groupRepeated(env, annotations);
        ImmutableList.Builder typeAnnotations = ImmutableList.builder();
        for (AnnoInfo anno : annotations) {
            ImmutableSet<TurbineElementType> target = DisambiguateTypeAnnotations.getTarget(env, anno);
            if (target.contains((Object)TurbineElementType.TYPE_USE)) {
                typeAnnotations.add((Object)anno);
            }
            if (!target.contains((Object)declarationTarget)) continue;
            declarationAnnotations.add((Object)anno);
        }
        return DisambiguateTypeAnnotations.addAnnotationsToType(type, (ImmutableList<AnnoInfo>)typeAnnotations.build());
    }

    private static ImmutableSet<TurbineElementType> getTarget(Env<ClassSymbol, TypeBoundClass> env, AnnoInfo anno) {
        ClassSymbol sym = anno.sym();
        if (sym == null) {
            return AnnotationMetadata.DEFAULT_TARGETS;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return AnnotationMetadata.DEFAULT_TARGETS;
        }
        AnnotationMetadata metadata = info.annotationMetadata();
        if (metadata == null) {
            return AnnotationMetadata.DEFAULT_TARGETS;
        }
        return metadata.target();
    }

    private static ImmutableList<TypeBoundClass.FieldInfo> bindFields(Env<ClassSymbol, TypeBoundClass> env, ImmutableList<TypeBoundClass.FieldInfo> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (TypeBoundClass.FieldInfo field : fields) {
            result.add((Object)DisambiguateTypeAnnotations.bindField(env, field));
        }
        return result.build();
    }

    private static TypeBoundClass.FieldInfo bindField(Env<ClassSymbol, TypeBoundClass> env, TypeBoundClass.FieldInfo base) {
        ImmutableList.Builder declarationAnnotations = ImmutableList.builder();
        Type type = DisambiguateTypeAnnotations.disambiguate(env, TurbineElementType.FIELD, base.type(), base.annotations(), (ImmutableList.Builder<AnnoInfo>)declarationAnnotations);
        return new TypeBoundClass.FieldInfo(base.sym(), type, base.access(), (ImmutableList<AnnoInfo>)declarationAnnotations.build(), base.decl(), base.value());
    }

    private static Type addAnnotationsToType(Type type, ImmutableList<AnnoInfo> extra) {
        switch (type.tyKind()) {
            case PRIM_TY: {
                Type.PrimTy primTy = (Type.PrimTy)type;
                return Type.PrimTy.create(primTy.primkind(), DisambiguateTypeAnnotations.appendAnnotations(primTy.annos(), extra));
            }
            case CLASS_TY: {
                Type.ClassTy classTy = (Type.ClassTy)type;
                Type.ClassTy.SimpleClassTy base = (Type.ClassTy.SimpleClassTy)classTy.classes().get(0);
                Type.ClassTy.SimpleClassTy simple = Type.ClassTy.SimpleClassTy.create(base.sym(), base.targs(), DisambiguateTypeAnnotations.appendAnnotations(base.annos(), extra));
                return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)ImmutableList.builder().add((Object)simple).addAll((Iterable)classTy.classes().subList(1, classTy.classes().size())).build());
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                return Type.ArrayTy.create(DisambiguateTypeAnnotations.addAnnotationsToType(arrayTy.elementType(), extra), arrayTy.annos());
            }
            case TY_VAR: {
                Type.TyVar tyVar = (Type.TyVar)type;
                return Type.TyVar.create(tyVar.sym(), DisambiguateTypeAnnotations.appendAnnotations(tyVar.annos(), extra));
            }
            case VOID_TY: 
            case ERROR_TY: {
                return type;
            }
            case WILD_TY: {
                throw new AssertionError((Object)"unexpected wildcard type outside type argument context");
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private static ImmutableList<AnnoInfo> appendAnnotations(ImmutableList<AnnoInfo> annos, ImmutableList<AnnoInfo> extra) {
        return ImmutableList.builder().addAll(annos).addAll(extra).build();
    }

    public static ImmutableList<AnnoInfo> groupRepeated(Env<ClassSymbol, TypeBoundClass> env, ImmutableList<AnnoInfo> annotations) {
        ListMultimap repeated = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        ImmutableList.Builder result = ImmutableList.builder();
        for (AnnoInfo anno : annotations) {
            if (anno.sym() == null) {
                result.add((Object)anno);
                continue;
            }
            repeated.put((Object)anno.sym(), (Object)anno);
        }
        for (Map.Entry entry : repeated.asMap().entrySet()) {
            ClassSymbol symbol = (ClassSymbol)entry.getKey();
            Collection infos = (Collection)entry.getValue();
            if (infos.size() > 1) {
                ImmutableList.Builder elements = ImmutableList.builder();
                for (AnnoInfo element : infos) {
                    elements.add((Object)new TurbineAnnotationValue(element));
                }
                TypeBoundClass info = env.get(symbol);
                if (info == null || info.annotationMetadata() == null) continue;
                ClassSymbol container = info.annotationMetadata().repeatable();
                if (container == null) {
                    if (DisambiguateTypeAnnotations.isKotlinRepeatable(info)) continue;
                    AnnoInfo anno = (AnnoInfo)infos.iterator().next();
                    throw TurbineError.format(anno.source(), anno.position(), TurbineError.ErrorKind.NONREPEATABLE_ANNOTATION, symbol);
                }
                result.add((Object)new AnnoInfo(null, container, null, (ImmutableMap<String, Const>)ImmutableMap.of((Object)"value", (Object)new Const.ArrayInitValue((ImmutableList<Const>)elements.build()))));
                continue;
            }
            result.add((Object)((AnnoInfo)Iterables.getOnlyElement((Iterable)infos)));
        }
        return result.build();
    }

    static boolean isKotlinRepeatable(TypeBoundClass info) {
        for (AnnoInfo metaAnno : info.annotations()) {
            if (metaAnno.sym() == null || !metaAnno.sym().binaryName().equals("kotlin/annotation/Repeatable")) continue;
            return true;
        }
        return false;
    }

    private DisambiguateTypeAnnotations() {
    }
}

