/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.core.AaptPackageProcessBuilder;
import com.android.builder.core.ApkInfoParser;
import com.android.builder.core.BuildToolsServiceLoader;
import com.android.builder.core.DexOptions;
import com.android.builder.core.DexProcessBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.JackProcessBuilder;
import com.android.builder.core.LibraryRequest;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.dependency.SymbolFileProvider;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.DexWrapper;
import com.android.builder.internal.compiler.JackConversionCache;
import com.android.builder.internal.compiler.LeafFolderGatherer;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.incremental.DependencyData;
import com.android.builder.internal.packaging.Packager;
import com.android.builder.model.ClassField;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.signing.SignedJarBuilder;
import com.android.builder.signing.SigningException;
import com.android.ide.common.internal.AaptCruncher;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.jack.api.ConfigNotSupportedException;
import com.android.jack.api.JackProvider;
import com.android.jack.api.v01.Api01CompilationTask;
import com.android.jack.api.v01.Api01Config;
import com.android.jack.api.v01.CompilationException;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.MultiDexKind;
import com.android.jack.api.v01.ReporterKind;
import com.android.jack.api.v01.UnrecoverableException;
import com.android.jill.api.JillProvider;
import com.android.jill.api.v01.Api01TranslationTask;
import com.android.jill.api.v01.TranslationException;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.repository.Revision;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Node;

public class AndroidBuilder {
    private static final Revision MIN_BUILD_TOOLS_REV = new Revision(19, 1, 0);
    private static final DependencyFileProcessor sNoOpDependencyFileProcessor = new DependencyFileProcessor(){

        @Override
        public DependencyData processFile(File dependencyFile) {
            return null;
        }
    };
    private final String mProjectId;
    private final ILogger mLogger;
    private final ProcessExecutor mProcessExecutor;
    private final JavaProcessExecutor mJavaProcessExecutor;
    private final ErrorReporter mErrorReporter;
    private final boolean mVerboseExec;
    private String mCreatedBy;
    private SdkInfo mSdkInfo;
    private TargetInfo mTargetInfo;
    private List<File> mBootClasspathFiltered;
    private List<File> mBootClasspathAll;
    private List<LibraryRequest> mLibraryRequests = ImmutableList.of();
    private static final Object LOCK_FOR_DEX = new Object();
    private static final AtomicInteger DEX_PROCESS_COUNT = new AtomicInteger(4);
    private static ExecutorService sDexExecutorService = null;
    private static final long DEFAULT_DEX_HEAP_SIZE = 0x40000000L;

    public AndroidBuilder(String projectId, String createdBy, ProcessExecutor processExecutor, JavaProcessExecutor javaProcessExecutor, ErrorReporter errorReporter, ILogger logger, boolean verboseExec) {
        this.mProjectId = (String)Preconditions.checkNotNull((Object)projectId);
        this.mCreatedBy = createdBy;
        this.mProcessExecutor = (ProcessExecutor)Preconditions.checkNotNull((Object)processExecutor);
        this.mJavaProcessExecutor = (JavaProcessExecutor)Preconditions.checkNotNull((Object)javaProcessExecutor);
        this.mErrorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
    }

    public void setTargetInfo(SdkInfo sdkInfo, TargetInfo targetInfo, Collection<LibraryRequest> libraryRequests) {
        this.mSdkInfo = sdkInfo;
        this.mTargetInfo = targetInfo;
        if (this.mTargetInfo.getBuildTools().getRevision().compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            throw new IllegalArgumentException(String.format("The SDK Build Tools revision (%1$s) is too low for project '%2$s'. Minimum required is %3$s", this.mTargetInfo.getBuildTools().getRevision(), this.mProjectId, MIN_BUILD_TOOLS_REV));
        }
        this.mLibraryRequests = ImmutableList.copyOf(libraryRequests);
    }

    public SdkInfo getSdkInfo() {
        return this.mSdkInfo;
    }

    public TargetInfo getTargetInfo() {
        return this.mTargetInfo;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public ErrorReporter getErrorReporter() {
        return this.mErrorReporter;
    }

    public IAndroidTarget getTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTarget() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget();
    }

    public boolean isPreviewTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call isTargetAPreview() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().isPreview();
    }

    public String getTargetCodename() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTargetCodename() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().getCodename();
    }

    public File getDxJar() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getDxJar() before setTargetInfo() is called.");
        return new File(this.mTargetInfo.getBuildTools().getPath(BuildToolInfo.PathId.DX_JAR));
    }

    public List<File> getBootClasspath(boolean includeOptionalLibraries) {
        if (includeOptionalLibraries) {
            return this.computeFullBootClasspath();
        }
        return this.computeFilteredBootClasspath();
    }

    private List<File> computeFilteredBootClasspath() {
        if (this.mBootClasspathFiltered == null) {
            Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
            ArrayList classpath = Lists.newArrayList();
            IAndroidTarget target = this.mTargetInfo.getTarget();
            for (String p : target.getBootClasspath()) {
                classpath.add(new File(p));
            }
            ArrayList requestedLibs = Lists.newArrayList(this.mLibraryRequests);
            List libs = target.getAdditionalLibraries();
            for (IAndroidTarget.OptionalLibrary lib : libs) {
                classpath.add(lib.getJar());
                LibraryRequest requestedLib = AndroidBuilder.findMatchingLib(lib.getName(), requestedLibs);
                if (requestedLib == null) continue;
                requestedLibs.remove(requestedLib);
            }
            List optionalLibraries = target.getOptionalLibraries();
            for (IAndroidTarget.OptionalLibrary lib : optionalLibraries) {
                LibraryRequest requestedLib = AndroidBuilder.findMatchingLib(lib.getName(), requestedLibs);
                if (requestedLib == null) continue;
                classpath.add(lib.getJar());
                requestedLibs.remove(requestedLib);
            }
            for (LibraryRequest library : requestedLibs) {
                this.mErrorReporter.handleSyncError(library.getName(), 10, "Unable to find optional library: " + library.getName());
            }
            if (target.getVersion().getApiLevel() <= 15) {
                classpath.add(this.mSdkInfo.getAnnotationsJar());
            }
            this.mBootClasspathFiltered = ImmutableList.copyOf((Collection)classpath);
        }
        return this.mBootClasspathFiltered;
    }

    private List<File> computeFullBootClasspath() {
        if (this.mBootClasspathAll == null) {
            Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
            ArrayList classpath = Lists.newArrayList();
            IAndroidTarget target = this.mTargetInfo.getTarget();
            for (String p : target.getBootClasspath()) {
                classpath.add(new File(p));
            }
            List libs = target.getAdditionalLibraries();
            for (IAndroidTarget.OptionalLibrary lib : libs) {
                classpath.add(lib.getJar());
            }
            List optionalLibraries = target.getOptionalLibraries();
            for (IAndroidTarget.OptionalLibrary lib : optionalLibraries) {
                classpath.add(lib.getJar());
            }
            if (target.getVersion().getApiLevel() <= 15) {
                classpath.add(this.mSdkInfo.getAnnotationsJar());
            }
            this.mBootClasspathAll = ImmutableList.copyOf((Collection)classpath);
        }
        return this.mBootClasspathAll;
    }

    private static LibraryRequest findMatchingLib(String name, List<LibraryRequest> libraries) {
        for (LibraryRequest library : libraries) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public List<String> getBootClasspathAsStrings(boolean includeOptionalLibraries) {
        List<File> classpath = this.getBootClasspath(includeOptionalLibraries);
        ArrayList results = Lists.newArrayListWithCapacity((int)classpath.size());
        for (File f : classpath) {
            results.add(f.getAbsolutePath());
        }
        return results;
    }

    public File getRenderScriptSupportJar() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportJar(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    public Set<File> getCompileClasspath(VariantConfiguration<?, ?, ?> variantConfiguration) {
        HashSet compileClasspath = variantConfiguration.getCompileClasspath();
        if (variantConfiguration.getRenderscriptSupportModeEnabled()) {
            File renderScriptSupportJar = this.getRenderScriptSupportJar();
            HashSet fullJars = Sets.newHashSetWithExpectedSize((int)(compileClasspath.size() + 1));
            fullJars.addAll(compileClasspath);
            if (renderScriptSupportJar != null) {
                fullJars.add(renderScriptSupportJar);
            }
            compileClasspath = fullJars;
        }
        return compileClasspath;
    }

    public Set<File> getAllPackagedJars(VariantConfiguration<?, ?, ?> variantConfiguration) {
        File renderScriptSupportJar;
        HashSet packagedJars = Sets.newHashSet(variantConfiguration.getAllPackagedJars());
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (renderScriptSupportJar = this.getRenderScriptSupportJar()) != null) {
            packagedJars.add(renderScriptSupportJar);
        }
        return packagedJars;
    }

    public Set<File> getAdditionalPackagedJars(VariantConfiguration<?, ?, ?> variantConfiguration) {
        File renderScriptSupportJar;
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (renderScriptSupportJar = this.getRenderScriptSupportJar()) != null) {
            return ImmutableSet.of((Object)renderScriptSupportJar);
        }
        return ImmutableSet.of();
    }

    public File getSupportNativeLibFolder() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportNativeLibFolder(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    public PngCruncher getAaptCruncher(ProcessOutputHandler processOutputHandler) {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getAaptCruncher() before setTargetInfo() is called.");
        return new AaptCruncher(this.mTargetInfo.getBuildTools().getPath(BuildToolInfo.PathId.AAPT), this.mProcessExecutor, processOutputHandler);
    }

    public ProcessExecutor getProcessExecutor() {
        return this.mProcessExecutor;
    }

    public ProcessResult executeProcess(ProcessInfo processInfo, ProcessOutputHandler handler) {
        return this.mProcessExecutor.execute(processInfo, handler);
    }

    public static ClassField createClassField(String type, String name, String value) {
        return new ClassFieldImpl(type, name, value);
    }

    public static String formatXml(Node node, boolean endWithNewline) {
        return XmlPrettyPrinter.prettyPrint((Node)node, (boolean)endWithNewline);
    }

    public void mergeManifests(File mainManifest, List<File> manifestOverlays, List<? extends ManifestDependency> libraries, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion, String outManifestLocation, String outAaptSafeManifestLocation, String outInstantRunManifestLocation, ManifestMerger2.MergeType mergeType, Map<String, Object> placeHolders, List<ManifestMerger2.Invoker.Feature> optionalFeatures, File reportFile) {
        try {
            ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(manifestOverlays.toArray(new File[manifestOverlays.size()])).addLibraryManifests(AndroidBuilder.collectLibraries(libraries)).withFeatures(optionalFeatures.toArray(new ManifestMerger2.Invoker.Feature[optionalFeatures.size()])).setMergeReportFile(reportFile);
            if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
            }
            if (outAaptSafeManifestLocation != null) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.MAKE_AAPT_SAFE});
            }
            AndroidBuilder.setInjectableValues(manifestMergerInvoker, packageOverride, versionCode, versionName, minSdkVersion, targetSdkVersion, maxSdkVersion);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            this.mLogger.info("Merging result:" + mergingReport.getResult(), new Object[0]);
            switch (mergingReport.getResult()) {
                case WARNING: {
                    mergingReport.log(this.mLogger);
                }
                case SUCCESS: {
                    String instantRunMergedManifest;
                    String xmlDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    }
                    AndroidBuilder.save(xmlDocument, new File(outManifestLocation));
                    this.mLogger.info("Merged manifest saved to " + outManifestLocation, new Object[0]);
                    if (outAaptSafeManifestLocation != null) {
                        AndroidBuilder.save(mergingReport.getMergedDocument(MergingReport.MergedManifestKind.AAPT_SAFE), new File(outAaptSafeManifestLocation));
                    }
                    if (outInstantRunManifestLocation != null && (instantRunMergedManifest = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.INSTANT_RUN)) != null) {
                        AndroidBuilder.save(instantRunMergedManifest, new File(outInstantRunManifestLocation));
                    }
                    break;
                }
                case ERROR: {
                    mergingReport.log(this.mLogger);
                    throw new RuntimeException(mergingReport.getReportString());
                }
                default: {
                    throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
                }
            }
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setInjectableValues(ManifestMerger2.Invoker<?> invoker, String packageOverride, int versionCode, String versionName, String minSdkVersion, String targetSdkVersion, Integer maxSdkVersion) {
        if (!Strings.isNullOrEmpty((String)packageOverride)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.PACKAGE, packageOverride);
        }
        if (versionCode > 0) {
            invoker.setOverride(ManifestMerger2.SystemProperty.VERSION_CODE, String.valueOf(versionCode));
        }
        if (!Strings.isNullOrEmpty((String)versionName)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.VERSION_NAME, versionName);
        }
        if (!Strings.isNullOrEmpty((String)minSdkVersion)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.MIN_SDK_VERSION, minSdkVersion);
        }
        if (!Strings.isNullOrEmpty((String)targetSdkVersion)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
        }
        if (maxSdkVersion != null) {
            invoker.setOverride(ManifestMerger2.SystemProperty.MAX_SDK_VERSION, maxSdkVersion.toString());
        }
    }

    private static void save(String xmlDocument, File out) {
        try {
            Files.createParentDirs((File)out);
            Files.write((CharSequence)xmlDocument, (File)out, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableList<Pair<String, File>> collectLibraries(List<? extends ManifestDependency> libraries) {
        ImmutableList.Builder manifestFiles = ImmutableList.builder();
        if (libraries != null) {
            AndroidBuilder.collectLibraries(libraries, (ImmutableList.Builder<Pair<String, File>>)manifestFiles);
        }
        return manifestFiles.build();
    }

    private static void collectLibraries(List<? extends ManifestDependency> libraries, ImmutableList.Builder<Pair<String, File>> manifestFiles) {
        for (ManifestDependency manifestDependency : libraries) {
            manifestFiles.add((Object)Pair.of((Object)manifestDependency.getName(), (Object)manifestDependency.getManifest()));
            List<? extends ManifestDependency> manifestDependencies = manifestDependency.getManifestDependencies();
            if (manifestDependencies.isEmpty()) continue;
            AndroidBuilder.collectLibraries(manifestDependencies, manifestFiles);
        }
    }

    public void processTestManifest(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, File testManifestFile, List<? extends ManifestDependency> libraries, Map<String, Object> manifestPlaceholders, File outManifest, File tmpDir) throws IOException {
        File tempFile2;
        block12: {
            Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
            Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
            Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
            Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
            Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
            Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
            Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
            File tempFile1 = null;
            tempFile2 = null;
            try {
                FileUtils.mkdirs((File)tmpDir);
                File generatedTestManifest = libraries.isEmpty() && testManifestFile == null ? outManifest : (tempFile1 = File.createTempFile("manifestMerger", ".xml", tmpDir));
                this.mLogger.verbose("Generating in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
                AndroidBuilder.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion.equals("-1") ? null : targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
                if (testManifestFile != null) {
                    tempFile2 = File.createTempFile("manifestMerger", ".xml", tmpDir);
                    this.mLogger.verbose("Merging user supplied manifest in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
                    ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)testManifestFile, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).setOverride(ManifestMerger2.SystemProperty.PACKAGE, testApplicationId).setPlaceHolderValues(manifestPlaceholders).setPlaceHolderValue("instrumentationRunner", instrumentationRunner).addLibraryManifests(new File[]{generatedTestManifest});
                    invoker.setOverride(ManifestMerger2.SystemProperty.MIN_SDK_VERSION, minSdkVersion);
                    if (!targetSdkVersion.equals("-1")) {
                        invoker.setOverride(ManifestMerger2.SystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
                    }
                    MergingReport mergingReport = invoker.merge();
                    if (libraries.isEmpty()) {
                        this.handleMergingResult(mergingReport, outManifest);
                    } else {
                        this.handleMergingResult(mergingReport, tempFile2);
                        generatedTestManifest = tempFile2;
                    }
                }
                if (!libraries.isEmpty()) {
                    MergingReport mergingReport = ManifestMerger2.newMerger((File)generatedTestManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS}).setOverride(ManifestMerger2.SystemProperty.PACKAGE, testApplicationId).addLibraryManifests(AndroidBuilder.collectLibraries(libraries)).setPlaceHolderValues(manifestPlaceholders).merge();
                    this.handleMergingResult(mergingReport, outManifest);
                }
                if (tempFile1 == null) break block12;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    if (tempFile1 != null) {
                        FileUtils.delete(tempFile1);
                    }
                    if (tempFile2 != null) {
                        FileUtils.delete(tempFile2);
                    }
                    throw throwable;
                }
            }
            FileUtils.delete((File)tempFile1);
        }
        if (tempFile2 != null) {
            FileUtils.delete((File)tempFile2);
        }
    }

    private void handleMergingResult(MergingReport mergingReport, File outFile) {
        switch (mergingReport.getResult()) {
            case WARNING: {
                mergingReport.log(this.mLogger);
            }
            case SUCCESS: {
                try {
                    String annotatedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.BLAME);
                    if (annotatedDocument != null) {
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    } else {
                        this.mLogger.verbose("No blaming records from manifest merger", new Object[0]);
                    }
                }
                catch (Exception e) {
                    this.mLogger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                }
                String finalMergedDocument = mergingReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
                if (finalMergedDocument == null) {
                    throw new RuntimeException("No result from manifest merger");
                }
                try {
                    Files.write((CharSequence)finalMergedDocument, (File)outFile, (Charset)Charsets.UTF_8);
                }
                catch (IOException e) {
                    this.mLogger.error((Throwable)e, "Cannot write resulting xml", new Object[0]);
                    throw new RuntimeException(e);
                }
                this.mLogger.info("Merged manifest saved to " + outFile, new Object[0]);
                break;
            }
            case ERROR: {
                mergingReport.log(this.mLogger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            default: {
                throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            }
        }
    }

    private static void generateTestManifest(String testApplicationId, String minSdkVersion, String targetSdkVersion, String testedApplicationId, String instrumentationRunner, Boolean handleProfiling, Boolean functionalTest, File outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processResources(AaptPackageProcessBuilder aaptCommand, boolean enforceUniquePackageName, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call processResources() before setTargetInfo() is called.");
        ProcessInfo processInfo = aaptCommand.build(this.mTargetInfo.getBuildTools(), this.mTargetInfo.getTarget(), this.mLogger);
        ProcessResult result = this.mProcessExecutor.execute(processInfo, processOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
        if (aaptCommand.getSourceOutputDir() != null && !aaptCommand.getLibraries().isEmpty()) {
            String msg;
            SymbolLoader fullSymbolValues = null;
            String appPackageName = aaptCommand.getPackageForR();
            if (appPackageName == null) {
                appPackageName = VariantConfiguration.getManifestPackage(aaptCommand.getManifestFile());
            }
            ArrayListMultimap libMap = ArrayListMultimap.create();
            for (SymbolFileProvider symbolFileProvider : aaptCommand.getLibraries()) {
                if (symbolFileProvider.isOptional()) continue;
                String packageName = VariantConfiguration.getManifestPackage(symbolFileProvider.getManifest());
                if (appPackageName == null) continue;
                if (appPackageName.equals(packageName)) {
                    if (!enforceUniquePackageName) continue;
                    msg = String.format("Error: A library uses the same package as this project: %s", packageName);
                    throw new RuntimeException(msg);
                }
                File rFile = symbolFileProvider.getSymbolFile();
                if (!rFile.isFile()) continue;
                if (fullSymbolValues == null) {
                    fullSymbolValues = new SymbolLoader(new File(aaptCommand.getSymbolOutputDir(), "R.txt"), this.mLogger);
                    fullSymbolValues.load();
                }
                SymbolLoader libSymbols = new SymbolLoader(rFile, this.mLogger);
                libSymbols.load();
                libMap.put((Object)packageName, (Object)libSymbols);
            }
            for (String string : libMap.keySet()) {
                Collection symbols = libMap.get((Object)string);
                if (enforceUniquePackageName && symbols.size() > 1) {
                    msg = String.format("Error: more than one library with package name '%s'", string);
                    throw new RuntimeException(msg);
                }
                SymbolWriter writer = new SymbolWriter(aaptCommand.getSourceOutputDir(), string, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
    }

    public void generateApkData(File apkFile, File outResFolder, String mainPkgName, String resName) throws ProcessException, IOException {
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null) {
            throw new IllegalStateException("Unable to get aapt location from Build Tools " + buildToolInfo.getRevision());
        }
        ApkInfoParser parser = new ApkInfoParser(new File(aapt), this.mProcessExecutor);
        ApkInfoParser.ApkInfo apkInfo = parser.parseApk(apkFile);
        if (!apkInfo.getPackageName().equals(mainPkgName)) {
            throw new RuntimeException("The main and the micro apps do not have the same package name.");
        }
        String content = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <versionCode>%2$s</versionCode>\n    <versionName>%3$s</versionName>\n    <rawPathResId>%4$s</rawPathResId>\n</wearableApp>", apkInfo.getPackageName(), apkInfo.getVersionCode(), apkInfo.getVersionName(), resName);
        File resXmlFile = new File(outResFolder, "xml");
        FileUtils.mkdirs((File)resXmlFile);
        Files.write((CharSequence)content, (File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8);
    }

    public static void generateApkDataEntryInManifest(int minSdkVersion, int targetSdkVersion, File manifestFile) throws InterruptedException, LoggedErrorException, IOException {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest package=\"\" xmlns:android=\"http://schemas.android.com/apk/res/android\">\n").append("            <uses-sdk android:minSdkVersion=\"").append(minSdkVersion).append("\"");
        if (targetSdkVersion != -1) {
            content.append(" android:targetSdkVersion=\"").append(targetSdkVersion).append("\"");
        }
        content.append("/>\n");
        content.append("    <application>\n").append("        <meta-data android:name=\"com.google.android.wearable.beta.app\"\n").append("                   android:resource=\"@xml/android_wear_micro_apk").append("\" />\n").append("   </application>\n").append("</manifest>\n");
        Files.write((CharSequence)content, (File)manifestFile, (Charset)Charsets.UTF_8);
    }

    public void compileAllAidlFiles(List<File> sourceFolders, File sourceOutputDir, File packagedOutputDir, Collection<String> packageWhiteList, List<File> importFolders, DependencyFileProcessor dependencyFileProcessor, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, LoggedErrorException, ProcessException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllAidlFiles() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders.size()));
        fullImportList.addAll(sourceFolders);
        fullImportList.addAll(importFolders);
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), fullImportList, sourceOutputDir, packagedOutputDir, packageWhiteList, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mProcessExecutor, processOutputHandler);
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "aidl");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileAidlFile(File sourceFolder, File aidlFile, File sourceOutputDir, File packagedOutputDir, Collection<String> packageWhitelist, List<File> importFolders, DependencyFileProcessor dependencyFileProcessor, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, LoggedErrorException, ProcessException {
        Preconditions.checkNotNull((Object)aidlFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAidlFile() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), importFolders, sourceOutputDir, packagedOutputDir, packageWhitelist, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mProcessExecutor, processOutputHandler);
        processor.processFile(sourceFolder, aidlFile);
    }

    public void compileAllRenderscriptFiles(List<File> sourceFolders, List<File> importFolders, File sourceOutputDir, File resOutputDir, File objOutputDir, File libOutputDir, int targetApi, boolean debugBuild, int optimLevel, boolean ndkMode, boolean supportMode, Set<String> abiFilters, ProcessOutputHandler processOutputHandler) throws InterruptedException, ProcessException, LoggedErrorException, IOException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull((Object)resOutputDir, (Object)"resOutputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllRenderscriptFiles() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String renderscript = buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        RenderScriptProcessor processor = new RenderScriptProcessor(sourceFolders, importFolders, sourceOutputDir, resOutputDir, objOutputDir, libOutputDir, buildToolInfo, targetApi, debugBuild, optimLevel, ndkMode, supportMode, abiFilters);
        processor.build(this.mProcessExecutor, processOutputHandler);
    }

    public static List<File> getLeafFolders(String extension, List<File> ... importFolders) {
        ArrayList results = Lists.newArrayList();
        if (importFolders != null) {
            for (List<File> folders : importFolders) {
                SourceSearcher searcher = new SourceSearcher(folders, extension);
                searcher.setUseExecutor(false);
                LeafFolderGatherer processor = new LeafFolderGatherer();
                try {
                    searcher.search(processor);
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                }
                catch (LoggedErrorException e) {
                }
                catch (ProcessException e) {
                    // empty catch block
                }
                results.addAll(processor.getFolders());
            }
        }
        return results;
    }

    public void convertByteCode(Collection<File> inputs, File outDexFolder, boolean multidex, File mainDexList, DexOptions dexOptions, List<String> additionalParameters, boolean incremental, boolean optimize, ProcessOutputHandler processOutputHandler, boolean instantRunMode) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkNotNull(inputs, (Object)"inputs cannot be null.");
        Preconditions.checkNotNull((Object)outDexFolder, (Object)"outDexFolder cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        Preconditions.checkArgument((boolean)outDexFolder.isDirectory(), (Object)"outDexFolder must be a folder");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call convertByteCode() before setTargetInfo() is called.");
        ImmutableList.Builder verifiedInputs = ImmutableList.builder();
        for (File input : inputs) {
            if (!AndroidBuilder.checkLibraryClassesJar(input)) continue;
            verifiedInputs.add((Object)input);
        }
        DexProcessBuilder builder = new DexProcessBuilder(outDexFolder);
        builder.setVerbose(this.mVerboseExec).setIncremental(incremental).setNoOptimize(!optimize).setMultiDex(multidex).setMainDexList(mainDexList).addInputs((Collection<File>)verifiedInputs.build());
        if (additionalParameters != null) {
            builder.additionalParameters(additionalParameters);
        }
        this.runDexer(builder, dexOptions, processOutputHandler, instantRunMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDexer(final DexProcessBuilder builder, final DexOptions dexOptions, final ProcessOutputHandler processOutputHandler, boolean instantRunMode) throws ProcessException, IOException, InterruptedException {
        Revision buildToolsVersion = this.mTargetInfo.getBuildTools().getRevision();
        if (AndroidBuilder.shouldDexInProcess(builder, dexOptions, buildToolsVersion, instantRunMode, this.getLogger())) {
            File dxJar = new File(this.mTargetInfo.getBuildTools().getPath(BuildToolInfo.PathId.DX_JAR));
            DexWrapper dexWrapper = DexWrapper.obtain(dxJar);
            try {
                ProcessResult result = dexWrapper.run(builder, dexOptions, processOutputHandler, this.mLogger);
                result.assertNormalExitValue();
            }
            finally {
                dexWrapper.release();
            }
        }
        Object dxJar = LOCK_FOR_DEX;
        synchronized (dxJar) {
            if (sDexExecutorService == null) {
                if (dexOptions.getMaxProcessCount() != null) {
                    DEX_PROCESS_COUNT.set(dexOptions.getMaxProcessCount());
                }
                this.getLogger().info("Allocated dexExecutorService of size %d", new Object[]{DEX_PROCESS_COUNT.get()});
                sDexExecutorService = Executors.newFixedThreadPool(DEX_PROCESS_COUNT.get());
            } else if (dexOptions.getMaxProcessCount() != null && dexOptions.getMaxProcessCount().intValue() != DEX_PROCESS_COUNT.get()) {
                this.getLogger().warning("dexOptions is specifying a maximum number of %1$d concurrent dx processes, but the Gradle daemon was initialized with %2$d.\nTo initialize with a different maximum value, first stop the Gradle daemon by calling \u2018gradlew \u2014-stop\u2019.", new Object[]{dexOptions.getMaxProcessCount(), DEX_PROCESS_COUNT.get()});
            }
        }
        try {
            final String submission = Joiner.on((char)',').join(builder.getInputs());
            if (submission.contains("dependencies.jar")) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                JavaProcessInfo javaProcessInfo = builder.build(this.mTargetInfo.getBuildTools(), dexOptions);
                ProcessResult result = this.mJavaProcessExecutor.execute(javaProcessInfo, processOutputHandler);
                result.rethrowFailure().assertNormalExitValue();
                this.getLogger().info("Dexing " + submission + " took " + stopwatch.toString(), new Object[0]);
            } else {
                sDexExecutorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        JavaProcessInfo javaProcessInfo = builder.build(AndroidBuilder.this.mTargetInfo.getBuildTools(), dexOptions);
                        ProcessResult result = AndroidBuilder.this.mJavaProcessExecutor.execute(javaProcessInfo, processOutputHandler);
                        result.rethrowFailure().assertNormalExitValue();
                        AndroidBuilder.this.getLogger().info("Dexing " + submission + " took " + stopwatch.toString(), new Object[0]);
                        return null;
                    }
                }).get();
            }
        }
        catch (ExecutionException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    static boolean shouldDexInProcess(DexProcessBuilder builder, DexOptions dexOptions, Revision buildToolsVersion, boolean instantRunMode, ILogger logger) {
        return false;
    }

    static long parseHeapSize(String sizeParameter) {
        if (sizeParameter == null) {
            return 0x40000000L;
        }
        long multiplier = 1L;
        if (SdkUtils.endsWithIgnoreCase((String)sizeParameter, (String)"k")) {
            multiplier = 1024L;
        } else if (SdkUtils.endsWithIgnoreCase((String)sizeParameter, (String)"m")) {
            multiplier = 0x100000L;
        } else if (SdkUtils.endsWithIgnoreCase((String)sizeParameter, (String)"g")) {
            multiplier = 0x40000000L;
        }
        if (multiplier != 1L) {
            sizeParameter = sizeParameter.substring(0, sizeParameter.length() - 1);
        }
        try {
            return multiplier * Long.parseLong(sizeParameter);
        }
        catch (NumberFormatException e) {
            return 0x40000000L;
        }
    }

    public Set<String> createMainDexList(File allClassesJarFile, File jarOfRoots) throws ProcessException {
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX_JAR);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx.jar is missing");
        }
        builder.setClasspath(dx);
        builder.setMain("com.android.multidex.ClassReferenceListBuilder");
        builder.addArgs(jarOfRoots.getAbsolutePath());
        builder.addArgs(allClassesJarFile.getAbsolutePath());
        CachedProcessOutputHandler processOutputHandler = new CachedProcessOutputHandler();
        this.mJavaProcessExecutor.execute(builder.createJavaProcess(), (ProcessOutputHandler)processOutputHandler).rethrowFailure().assertNormalExitValue();
        String content = processOutputHandler.getProcessOutput().getStandardOutputAsString();
        return Sets.newHashSet((Iterable)Splitter.on((char)'\n').split((CharSequence)content));
    }

    public void preDexLibrary(File inputFile, File outFile, boolean multiDex, DexOptions dexOptions, ProcessOutputHandler processOutputHandler) throws IOException, InterruptedException, ProcessException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call preDexLibrary() before setTargetInfo() is called.");
        PreDexCache.getCache().preDexLibrary(this, inputFile, outFile, multiDex, dexOptions, processOutputHandler);
    }

    public ImmutableList<File> preDexLibraryNoCache(File inputFile, File outFile, boolean multiDex, DexOptions dexOptions, ProcessOutputHandler processOutputHandler) throws ProcessException, IOException, InterruptedException {
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile cannot be null.");
        Preconditions.checkNotNull((Object)outFile, (Object)"outFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        try {
            if (!AndroidBuilder.checkLibraryClassesJar(inputFile)) {
                return ImmutableList.of();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while checking library jar", e);
        }
        DexProcessBuilder builder = new DexProcessBuilder(outFile);
        builder.setVerbose(this.mVerboseExec).setMultiDex(multiDex).addInput(inputFile);
        this.runDexer(builder, dexOptions, processOutputHandler, false);
        if (multiDex) {
            Object[] files = outFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.endsWith(".dex");
                }
            });
            if (files == null || files.length == 0) {
                throw new RuntimeException("No dex files created at " + outFile.getAbsolutePath());
            }
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of((Object)outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkLibraryClassesJar(File input) throws IOException {
        if (!input.exists()) {
            return false;
        }
        if (input.isDirectory()) {
            return AndroidBuilder.checkFolder(input);
        }
        ZipFile zipFile = new ZipFile(input);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class") && !name.endsWith(".dex")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            zipFile.close();
        }
    }

    private static boolean checkFolder(File folder) {
        File[] subFolders = folder.listFiles();
        if (subFolders != null) {
            for (File childFolder : subFolders) {
                String name;
                if (childFolder.isFile() && ((name = childFolder.getName()).endsWith(".class") || name.endsWith(".dex"))) {
                    return true;
                }
                if (!childFolder.isDirectory() || !AndroidBuilder.checkFolder(childFolder)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean convertByteCodeUsingJackApis(File dexOutputFolder, File jackOutputFile, Collection<File> classpath, Collection<File> packagedLibraries, Collection<File> sourceFiles, Collection<File> proguardFiles, File mappingFile, Collection<File> jarJarRulesFiles, File incrementalDir, File javaResourcesFolder, boolean multiDex, int minSdkVersion) {
        BuildToolsServiceLoader.BuildToolServiceLoader buildToolServiceLoader = BuildToolsServiceLoader.INSTANCE.forVersion(this.mTargetInfo.getBuildTools());
        Api01CompilationTask compilationTask = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Optional<JackProvider> jackProvider = buildToolServiceLoader.getSingleService(this.getLogger(), BuildToolsServiceLoader.JACK);
            if (jackProvider.isPresent()) {
                try {
                    Api01Config config = (Api01Config)((JackProvider)jackProvider.get()).createConfig(Api01Config.class);
                    config.setClasspath(new ArrayList<File>(classpath));
                    config.setOutputDexDir(dexOutputFolder);
                    config.setOutputJackFile(jackOutputFile);
                    config.setImportedJackLibraryFiles(new ArrayList<File>(packagedLibraries));
                    if (proguardFiles != null) {
                        config.setProguardConfigFiles(new ArrayList<File>(proguardFiles));
                    }
                    if (!jarJarRulesFiles.isEmpty()) {
                        config.setJarJarConfigFiles((List)ImmutableList.copyOf(jarJarRulesFiles));
                    }
                    if (multiDex) {
                        if (minSdkVersion < 21) {
                            config.setMultiDexKind(MultiDexKind.LEGACY);
                        } else {
                            config.setMultiDexKind(MultiDexKind.NATIVE);
                        }
                    }
                    config.setSourceEntries(new ArrayList<File>(sourceFiles));
                    if (mappingFile != null) {
                        config.setProperty("jack.obfuscation.mapping.dump", "true");
                        config.setObfuscationMappingOutputFile(mappingFile);
                    }
                    config.setProperty("jack.import.resource.policy", "keep-first");
                    config.setReporter(ReporterKind.DEFAULT, (OutputStream)outputStream);
                    if (incrementalDir != null) {
                        if (!incrementalDir.exists() && !incrementalDir.mkdirs()) {
                            this.mLogger.warning("Cannot create %1$s directory, jack incremental support disabled", new Object[]{incrementalDir});
                        }
                        if (incrementalDir.exists()) {
                            config.setIncrementalDir(incrementalDir);
                        }
                    }
                    if (javaResourcesFolder != null) {
                        ArrayList folders = Lists.newArrayListWithExpectedSize((int)3);
                        folders.add(javaResourcesFolder);
                        config.setResourceDirs((List)folders);
                    }
                    compilationTask = config.getTask();
                }
                catch (ConfigNotSupportedException e1) {
                    this.mLogger.warning("Jack APIs v01 not supported", new Object[0]);
                }
                catch (ConfigurationException e) {
                    this.mLogger.error((Throwable)e, "Jack APIs v01 configuration failed, reverting to native process", new Object[0]);
                }
            }
            if (compilationTask == null) {
                return false;
            }
            try {
                compilationTask.run();
                this.mLogger.info(outputStream.toString(), new Object[0]);
                return true;
            }
            catch (CompilationException e) {
                this.mLogger.error((Throwable)e, outputStream.toString(), new Object[0]);
            }
            catch (UnrecoverableException e) {
                this.mLogger.error((Throwable)e, "Something out of Jack control has happened: " + e.getMessage(), new Object[0]);
            }
            catch (ConfigurationException e) {
                this.mLogger.error((Throwable)e, outputStream.toString(), new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warning("Cannot load Jack APIs v01 " + e.getMessage(), new Object[0]);
            this.getLogger().warning("Reverting to native process invocation", new Object[0]);
        }
        return false;
    }

    public void convertByteCodeWithJack(File dexOutputFolder, File jackOutputFile, String classpath, Collection<File> packagedLibraries, File ecjOptionFile, Collection<File> proguardFiles, File mappingFile, Collection<File> jarJarRuleFiles, boolean multiDex, int minSdkVersion, boolean debugLog, String javaMaxHeapSize, ProcessOutputHandler processOutputHandler) throws ProcessException {
        JackProcessBuilder builder = new JackProcessBuilder();
        builder.setDebugLog(debugLog).setVerbose(this.mVerboseExec).setJavaMaxHeapSize(javaMaxHeapSize).setClasspath(classpath).setDexOutputFolder(dexOutputFolder).setJackOutputFile(jackOutputFile).addImportFiles(packagedLibraries).setEcjOptionFile(ecjOptionFile);
        if (proguardFiles != null) {
            builder.addProguardFiles(proguardFiles).setMappingFile(mappingFile);
        }
        if (multiDex) {
            builder.setMultiDex(true).setMinSdkVersion(minSdkVersion);
        }
        builder.setJarJarRuleFiles(jarJarRuleFiles);
        this.mJavaProcessExecutor.execute(builder.build(this.mTargetInfo.getBuildTools()), processOutputHandler).rethrowFailure().assertNormalExitValue();
    }

    public void convertLibraryToJack(File inputFile, File outFile, DexOptions dexOptions, ProcessOutputHandler processOutputHandler) throws ProcessException, IOException, InterruptedException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call preJackLibrary() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        JackConversionCache.getCache().convertLibrary(inputFile, outFile, dexOptions, buildToolInfo, this.mVerboseExec, this.mJavaProcessExecutor, processOutputHandler, this.mLogger);
    }

    public static List<File> convertLibaryToJackUsingApis(File inputFile, File outFile, DexOptions dexOptions, BuildToolInfo buildToolInfo, boolean verbose, JavaProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, ILogger logger) throws ProcessException {
        BuildToolsServiceLoader.BuildToolServiceLoader buildToolServiceLoader = BuildToolsServiceLoader.INSTANCE.forVersion(buildToolInfo);
        if (System.getenv("USE_JACK_API") != null) {
            try {
                Optional<JillProvider> jillProviderOptional = buildToolServiceLoader.getSingleService(logger, BuildToolsServiceLoader.JILL);
                if (jillProviderOptional.isPresent()) {
                    com.android.jill.api.v01.Api01Config config = (com.android.jill.api.v01.Api01Config)((JillProvider)jillProviderOptional.get()).createConfig(com.android.jill.api.v01.Api01Config.class);
                    config.setInputJavaBinaryFile(inputFile);
                    config.setOutputJackFile(outFile);
                    config.setVerbose(verbose);
                    Api01TranslationTask translationTask = config.getTask();
                    translationTask.run();
                    return ImmutableList.of((Object)outFile);
                }
            }
            catch (ClassNotFoundException e) {
                logger.warning("Cannot find the jill tool in the classpath, reverting to native", new Object[0]);
            }
            catch (com.android.jill.api.ConfigNotSupportedException e) {
                logger.warning(e.getMessage() + ", reverting to native", new Object[0]);
            }
            catch (com.android.jill.api.v01.ConfigurationException e) {
                logger.warning(e.getMessage() + ", reverting to native", new Object[0]);
            }
            catch (TranslationException e) {
                logger.error((Throwable)e, "In process translation failed, reverting to native, file a bug", new Object[0]);
            }
        }
        return AndroidBuilder.convertLibraryToJack(inputFile, outFile, dexOptions, buildToolInfo, verbose, processExecutor, processOutputHandler, logger);
    }

    public static List<File> convertLibraryToJack(File inputFile, File outFile, DexOptions dexOptions, BuildToolInfo buildToolInfo, boolean verbose, JavaProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, ILogger logger) throws ProcessException {
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile cannot be null.");
        Preconditions.checkNotNull((Object)outFile, (Object)"outFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String jill = buildToolInfo.getPath(BuildToolInfo.PathId.JILL);
        if (jill == null || !new File(jill).isFile()) {
            throw new IllegalStateException("jill.jar is missing");
        }
        builder.setClasspath(jill);
        builder.setMain("com.android.jill.Main");
        if (dexOptions.getJavaMaxHeapSize() != null) {
            builder.addJvmArg("-Xmx" + dexOptions.getJavaMaxHeapSize());
        }
        builder.addArgs(inputFile.getAbsolutePath());
        builder.addArgs("--output");
        builder.addArgs(outFile.getAbsolutePath());
        if (verbose) {
            builder.addArgs("--verbose");
        }
        logger.verbose(builder.toString(), new Object[0]);
        JavaProcessInfo javaProcessInfo = builder.createJavaProcess();
        ProcessResult result = processExecutor.execute(javaProcessInfo, processOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
        return Collections.singletonList(outFile);
    }

    public void packageApk(String androidResPkgLocation, Set<File> dexFolders, Collection<File> javaResourcesLocations, Collection<File> jniLibsLocations, Set<String> abiFilters, boolean jniDebugBuild, SigningConfig signingConfig, String outApkLocation, int minSdkVersion) throws DuplicateFileException, FileNotFoundException, KeytoolException, PackagerException, com.android.builder.packaging.SigningException {
        Preconditions.checkNotNull((Object)androidResPkgLocation, (Object)"androidResPkgLocation cannot be null.");
        Preconditions.checkNotNull((Object)outApkLocation, (Object)"outApkLocation cannot be null.");
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady()) {
            certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)signingConfig.getStoreFile(), (String)signingConfig.getStorePassword(), (String)signingConfig.getKeyPassword(), (String)signingConfig.getKeyAlias());
        }
        try {
            Packager packager = new Packager(outApkLocation, androidResPkgLocation, certificateInfo, this.mCreatedBy, this.mLogger, minSdkVersion);
            if (!dexFolders.isEmpty()) {
                packager.addDexFiles(dexFolders);
            }
            packager.setJniDebugMode(jniDebugBuild);
            for (File javaResourcesLocation : javaResourcesLocations) {
                packager.addResources(javaResourcesLocation);
            }
            for (File jniLibsLocation : jniLibsLocations) {
                packager.addNativeLibraries(jniLibsLocation, abiFilters);
            }
            packager.sealApk();
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }

    public void packageCodeSplitApk(String androidResPkgLocation, File dexFile, SigningConfig signingConfig, String outApkLocation) throws FileNotFoundException, KeytoolException, PackagerException, DuplicateFileException {
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady()) {
            certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)signingConfig.getStoreFile(), (String)signingConfig.getStorePassword(), (String)signingConfig.getKeyPassword(), (String)signingConfig.getKeyAlias());
        }
        try {
            Packager packager = new Packager(outApkLocation, androidResPkgLocation, certificateInfo, this.mCreatedBy, this.mLogger, 23);
            packager.addFile(dexFile, "classes.dex");
            packager.sealApk();
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }

    public void signApk(File in, SigningConfig signingConfig, File out) throws IOException, KeytoolException, com.android.builder.packaging.SigningException, NoSuchAlgorithmException, SignedJarBuilder.IZipEntryFilter.ZipAbortException, SigningException {
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady()) {
            certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)signingConfig.getStoreFile(), (String)signingConfig.getStorePassword(), (String)signingConfig.getKeyPassword(), (String)signingConfig.getKeyAlias());
        }
        SignedJarBuilder signedJarBuilder = new SignedJarBuilder(new FileOutputStream(out), certificateInfo != null ? certificateInfo.getKey() : null, certificateInfo != null ? certificateInfo.getCertificate() : null, Packager.getLocalVersion(), this.mCreatedBy, 1);
        signedJarBuilder.writeZip(new FileInputStream(in));
        signedJarBuilder.close();
    }
}

