/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;

@BugPattern(summary="Prefer ErrorProne's @CheckReturnValue over JSR305's version.", severity=BugPattern.SeverityLevel.WARNING)
public final class UsingJsr305CheckReturnValue
extends BugChecker
implements BugChecker.ImportTreeMatcher {
    private static final String EP_CRV = "com.google.errorprone.annotations.CheckReturnValue";
    private static final String JSR305_CRV = "javax.annotation.CheckReturnValue";
    private static final Supplier<Type> JSR305_TYPE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(JSR305_CRV));

    public Description matchImport(ImportTree tree, VisitorState state) {
        Type jsr305Type = (Type)JSR305_TYPE.get(state);
        if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getQualifiedIdentifier()), (Type)jsr305Type, (VisitorState)state)) {
            SuggestedFix fix = SuggestedFix.builder().removeImport(JSR305_CRV).addImport(EP_CRV).build();
            return this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }
}

