/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.turbine.options.LanguageVersion;
import com.google.turbine.options.TurbineOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Deque;

public final class TurbineOptionsParser {
    public static TurbineOptions parse(Iterable<String> args) throws IOException {
        TurbineOptions.Builder builder = TurbineOptions.builder();
        TurbineOptionsParser.parse(builder, args);
        return builder.build();
    }

    public static void parse(TurbineOptions.Builder builder, Iterable<String> args) throws IOException {
        ArrayDeque<String> argumentDeque = new ArrayDeque<String>();
        TurbineOptionsParser.expandParamsFiles(argumentDeque, args);
        TurbineOptionsParser.parse(builder, argumentDeque);
    }

    private static void parse(TurbineOptions.Builder builder, Deque<String> argumentDeque) {
        block69: while (!argumentDeque.isEmpty()) {
            String next;
            switch (next = argumentDeque.removeFirst()) {
                case "--output": {
                    builder.setOutput(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--source_jars": {
                    builder.setSourceJars(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--temp_dir": {
                    TurbineOptionsParser.readOne(next, argumentDeque);
                    continue block69;
                }
                case "--processors": {
                    builder.setProcessors(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--builtin_processors": {
                    builder.setBuiltinProcessors(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--processorpath": {
                    builder.setProcessorPath(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--classpath": {
                    builder.setClassPath(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--bootclasspath": {
                    builder.setBootClassPath(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--system": {
                    builder.setSystem(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--javacopts": {
                    ImmutableList<String> javacOpts = TurbineOptionsParser.readJavacopts(argumentDeque);
                    builder.setLanguageVersion(LanguageVersion.fromJavacopts(javacOpts));
                    builder.addAllJavacOpts((Iterable<String>)javacOpts);
                    continue block69;
                }
                case "--sources": {
                    builder.setSources(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--output_deps_proto": 
                case "--output_deps": {
                    builder.setOutputDeps(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--output_manifest_proto": {
                    builder.setOutputManifest(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--direct_dependencies": {
                    builder.setDirectJars(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--deps_artifacts": {
                    builder.setDepsArtifacts(TurbineOptionsParser.readList(argumentDeque));
                    continue block69;
                }
                case "--target_label": {
                    builder.setTargetLabel(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--injecting_rule_kind": {
                    builder.setInjectingRuleKind(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--javac_fallback": 
                case "--nojavac_fallback": {
                    continue block69;
                }
                case "--reduce_classpath": {
                    builder.setReducedClasspathMode(TurbineOptions.ReducedClasspathMode.JAVABUILDER_REDUCED);
                    continue block69;
                }
                case "--noreduce_classpath": {
                    builder.setReducedClasspathMode(TurbineOptions.ReducedClasspathMode.NONE);
                    continue block69;
                }
                case "--reduce_classpath_mode": {
                    builder.setReducedClasspathMode(TurbineOptions.ReducedClasspathMode.valueOf(TurbineOptionsParser.readOne(next, argumentDeque)));
                    continue block69;
                }
                case "--full_classpath_length": {
                    builder.setFullClasspathLength(Integer.parseInt(TurbineOptionsParser.readOne(next, argumentDeque)));
                    continue block69;
                }
                case "--reduced_classpath_length": {
                    builder.setReducedClasspathLength(Integer.parseInt(TurbineOptionsParser.readOne(next, argumentDeque)));
                    continue block69;
                }
                case "--profile": {
                    builder.setProfile(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--generated_sources_output": 
                case "--gensrc_output": {
                    builder.setGensrcOutput(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--resource_output": {
                    builder.setResourceOutput(TurbineOptionsParser.readOne(next, argumentDeque));
                    continue block69;
                }
                case "--help": {
                    builder.setHelp(true);
                    continue block69;
                }
                case "--experimental_fix_deps_tool": 
                case "--strict_java_deps": 
                case "--native_header_output": {
                    TurbineOptionsParser.readOne(next, argumentDeque);
                    continue block69;
                }
                case "--post_processor": {
                    ImmutableList<String> unused = TurbineOptionsParser.readList(argumentDeque);
                    continue block69;
                }
                case "--compress_jar": {
                    continue block69;
                }
            }
            throw new IllegalArgumentException("unknown option: " + next);
        }
    }

    private static void expandParamsFiles(Deque<String> argumentDeque, Iterable<String> args) throws IOException {
        for (String arg : args) {
            if (arg.isEmpty()) continue;
            if (arg.charAt(0) == '\'') {
                Preconditions.checkArgument((arg.charAt(arg.length() - 1) == '\'' ? 1 : 0) != 0, (Object)arg);
                arg = arg.substring(1, arg.length() - 1);
                Preconditions.checkArgument((!arg.contains("'") ? 1 : 0) != 0, (Object)arg);
            }
            if (arg.startsWith("@@")) {
                argumentDeque.addLast(arg.substring(1));
                continue;
            }
            if (arg.startsWith("@")) {
                Path paramsPath = Paths.get(arg.substring(1), new String[0]);
                if (!Files.exists(paramsPath, new LinkOption[0])) {
                    throw new AssertionError((Object)("params file does not exist: " + String.valueOf(paramsPath)));
                }
                TurbineOptionsParser.expandParamsFiles(argumentDeque, Files.readAllLines(paramsPath));
                continue;
            }
            argumentDeque.addLast(arg);
        }
    }

    private static String readOne(String flag, Deque<String> argumentDeque) {
        if (argumentDeque.isEmpty() || argumentDeque.getFirst().startsWith("-")) {
            throw new IllegalArgumentException("missing required argument for: " + flag);
        }
        return argumentDeque.removeFirst();
    }

    private static ImmutableList<String> readList(Deque<String> argumentDeque) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!argumentDeque.isEmpty() && !argumentDeque.getFirst().startsWith("--")) {
            result.add((Object)argumentDeque.removeFirst());
        }
        return result.build();
    }

    private static ImmutableList<String> readJavacopts(Deque<String> argumentDeque) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!argumentDeque.isEmpty()) {
            String arg = argumentDeque.removeFirst();
            if (arg.equals("--")) {
                return result.build();
            }
            result.add((Object)arg);
        }
        throw new IllegalArgumentException("javacopts should be terminated by `--`");
    }

    private TurbineOptionsParser() {
    }
}

