/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfNormProfiler
implements ExternalProfiler {
    private static final String[] interestingEvents = new String[]{"cycles", "instructions", "branches", "branch-misses", "L1-dcache-loads", "L1-dcache-load-misses", "L1-dcache-stores", "L1-dcache-store-misses", "L1-icache-loads", "L1-icache-load-misses", "LLC-loads", "LLC-load-misses", "LLC-stores", "LLC-store-misses", "dTLB-loads", "dTLB-load-misses", "dTLB-stores", "dTLB-store-misses", "iTLB-loads", "iTLB-load-misses", "stalled-cycles-frontend", "stalled-cycles-backend"};
    private final int delayMs;
    private final int lengthMs;
    private final boolean useDefaultStats;
    private final int incrementInterval;
    private final boolean doFilter;
    private final Collection<String> supportedEvents = new ArrayList<String>();

    public LinuxPerfNormProfiler(String initLine) throws ProfilerException {
        List userEvents;
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new ProfilerOptionFormatter("perfnorm"));
        ArgumentAcceptingOptionSpec optEvents = parser.accepts("events", "Events to gather.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("event+");
        ArgumentAcceptingOptionSpec optDelay = parser.accepts("delay", "Delay collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optLength = parser.accepts("length", "Do the collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optIncrementInterval = parser.accepts("interval", "The interval between incremental updates from a concurrently running perf. Lower values may improve accuracy, while increasing the profiling overhead.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo((Object)100, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optFilter = parser.accepts("filter", "Filter problematic samples from infrastructure and perf itself.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)true, (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec optDefaultStat = parser.accepts("useDefaultStat", "Use \"perf stat -d -d -d\" instead of explicit counter list.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)false, (Object[])new Boolean[0]);
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.delayMs = (Integer)set.valueOf((OptionSpec)optDelay);
            this.lengthMs = (Integer)set.valueOf((OptionSpec)optLength);
            this.incrementInterval = (Integer)set.valueOf((OptionSpec)optIncrementInterval);
            this.doFilter = (Boolean)set.valueOf((OptionSpec)optFilter);
            this.useDefaultStats = (Boolean)set.valueOf((OptionSpec)optDefaultStat);
            userEvents = set.valuesOf((OptionSpec)optEvents);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> msgs = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "echo", "1");
        if (!msgs.isEmpty()) {
            throw new ProfilerException(msgs.toString());
        }
        Collection<String> incremental = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--interval-print", String.valueOf(this.incrementInterval), "echo", "1");
        if (!incremental.isEmpty()) {
            throw new ProfilerException("\\\"perf\\\" is too old, needs incremental mode (-I).");
        }
        ArrayList<String> candidateEvents = new ArrayList<String>();
        if (userEvents != null) {
            for (String ev : userEvents) {
                if (ev.trim().isEmpty()) continue;
                candidateEvents.add(ev);
            }
        }
        if (candidateEvents.isEmpty()) {
            candidateEvents.addAll(Arrays.asList(interestingEvents));
        }
        for (String ev : candidateEvents) {
            Collection<String> out;
            String[] senseCmd = new String[]{PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--event", ev, "echo", "1"};
            Collection<String> res = Utils.tryWith(senseCmd);
            if (!res.isEmpty() || PerfSupport.containsUnsupported(out = Utils.runWith(senseCmd), ev)) continue;
            this.supportedEvents.add(ev);
        }
        if (!this.useDefaultStats && this.supportedEvents.isEmpty()) {
            throw new ProfilerException("No supported events.");
        }
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.useDefaultStats) {
            cmd.addAll(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--detailed", "--detailed", "--detailed"));
        } else {
            cmd.addAll(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--event", Utils.join(this.supportedEvents, ",")));
        }
        cmd.addAll(Arrays.asList("-I", String.valueOf(this.incrementInterval)));
        return cmd;
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return this.process(br, stdOut, stdErr);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Linux perf statistics, normalized by operation count";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Collection<? extends Result> process(BenchmarkResult br, File stdOut, File stdErr) {
        HashMultimap<Object, EventRecord> eventRecords = new HashMultimap<Object, EventRecord>();
        try (FileReader fr = new FileReader(stdErr);){
            ArrayList<PerfResult> arrayList;
            double opsThroughput;
            HashMap<Object, Double> finalThroughputs;
            BufferedReader reader;
            block33: {
                long timeMs;
                BenchmarkResultMetaData md;
                block32: {
                    block31: {
                        Object key2;
                        String line;
                        reader = new BufferedReader(fr);
                        long skipMs = this.delayMs == -1 ? ProfilerUtils.measurementDelayMs(br) : (long)this.delayMs;
                        double lenMs = this.lengthMs == -1 ? (double)ProfilerUtils.measuredTimeMs(br) : (double)this.lengthMs;
                        double readFrom = (double)skipMs / 1000.0;
                        double readTo = ((double)skipMs + lenMs + (double)this.incrementInterval) / 1000.0;
                        NumberFormat nf = NumberFormat.getInstance();
                        while ((line = reader.readLine()) != null) {
                            String event;
                            String count;
                            Object time;
                            if (line.startsWith("#")) continue;
                            String[] split = line.split(",");
                            if (split.length == 3) {
                                time = split[0].trim();
                                count = split[1].trim();
                                event = split[2].trim();
                            } else {
                                if (split.length < 4) continue;
                                time = split[0].trim();
                                count = split[1].trim();
                                event = split[3].trim();
                            }
                            double timeSec = 0.0;
                            try {
                                timeSec = nf.parse((String)time).doubleValue();
                            }
                            catch (ParseException e) {
                                continue;
                            }
                            if (timeSec < readFrom || timeSec > readTo) continue;
                            long lValue = 0L;
                            try {
                                lValue = nf.parse(count).longValue();
                            }
                            catch (ParseException e) {
                                continue;
                            }
                            eventRecords.put(event, new EventRecord(timeSec, lValue));
                        }
                        finalThroughputs = new HashMap<Object, Double>();
                        for (Object key2 : eventRecords.keys()) {
                            List<Object> countedEvents = new ArrayList(eventRecords.get(key2));
                            int filteredCount = countedEvents.size() - 2;
                            if (this.doFilter && filteredCount > 0) {
                                countedEvents = countedEvents.subList(0, filteredCount);
                            }
                            double s = 0.0;
                            double minTime = Double.MAX_VALUE;
                            double maxTime = Double.MIN_VALUE;
                            for (int i = 0; i < countedEvents.size(); ++i) {
                                EventRecord v = (EventRecord)countedEvents.get(i);
                                if (i != 0) {
                                    s += v.value;
                                }
                                minTime = Math.min(minTime, v.time);
                                maxTime = Math.max(maxTime, v.time);
                            }
                            double thr = s / (maxTime - minTime);
                            finalThroughputs.put(key2, thr);
                        }
                        md = br.getMetadata();
                        if (md != null) break block31;
                        key2 = LinuxPerfNormProfiler.emptyResults();
                        reader.close();
                        return key2;
                    }
                    timeMs = md.getStopTime() - md.getMeasurementTime();
                    if (timeMs != 0L) break block32;
                    Set<PerfResult> filteredCount = LinuxPerfNormProfiler.emptyResults();
                    reader.close();
                    return filteredCount;
                }
                opsThroughput = 1000.0 * (double)md.getMeasurementOps() / (double)timeMs;
                if (opsThroughput != 0.0) break block33;
                Set<PerfResult> lValue = LinuxPerfNormProfiler.emptyResults();
                reader.close();
                return lValue;
            }
            try {
                Double instructions;
                ArrayList<PerfResult> results = new ArrayList<PerfResult>();
                for (String key : finalThroughputs.keySet()) {
                    results.add(new PerfResult(key, "#/op", (Double)finalThroughputs.get(key) / opsThroughput));
                }
                Double c1 = (Double)finalThroughputs.get("cycles");
                Double c2 = (Double)finalThroughputs.get("cycles:u");
                Double i1 = (Double)finalThroughputs.get("instructions");
                Double i2 = (Double)finalThroughputs.get("instructions:u");
                Double cycles = c1 != null ? c1 : c2;
                Double d = instructions = i1 != null ? i1 : i2;
                if (cycles != null && instructions != null && cycles != 0.0 && instructions != 0.0) {
                    results.add(new PerfResult("CPI", "clks/insn", cycles / instructions));
                    results.add(new PerfResult("IPC", "insns/clk", instructions / cycles));
                }
                arrayList = results;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            reader.close();
            return arrayList;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Set<PerfResult> emptyResults() {
        return Collections.singleton(new PerfResult("N/A", "", Double.NaN));
    }

    private static class EventRecord {
        final double time;
        final double value;

        public EventRecord(double time, double value) {
            this.time = time;
            this.value = value;
        }
    }

    static class PerfResult
    extends ScalarResult {
        private static final long serialVersionUID = -1262685915873231436L;

        public PerfResult(String key, String unit, double value) {
            super(key, value, unit, AggregationPolicy.AVG);
        }

        @Override
        public String extendedInfo() {
            return "";
        }
    }
}

