/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.json;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

final class ImmutableMapTypeAdapterFactory
implements TypeAdapterFactory {
    @Inject
    ImmutableMapTypeAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (typeToken.getRawType() != ImmutableMap.class || !(type instanceof ParameterizedType)) {
            return null;
        }
        com.google.common.reflect.TypeToken betterToken = com.google.common.reflect.TypeToken.of((Type)typeToken.getType());
        final TypeAdapter hashMapAdapter = gson.getAdapter(TypeToken.get((Type)betterToken.getSupertype(Map.class).getSubtype(HashMap.class).getType()));
        return new TypeAdapter<T>(this){

            public void write(JsonWriter out, T value) throws IOException {
                HashMap hashMap = Maps.newHashMap((Map)((Map)value));
                hashMapAdapter.write(out, (Object)hashMap);
            }

            public T read(JsonReader in) throws IOException {
                HashMap hashMap = (HashMap)hashMapAdapter.read(in);
                return ImmutableMap.copyOf((Map)hashMap);
            }
        };
    }
}

