/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.caliper.util.Stderr;
import com.google.caliper.util.Stdout;
import com.google.common.base.Preconditions;
import dagger.Module;
import dagger.Provides;
import java.io.PrintWriter;

@Module
public final class OutputModule {
    private final PrintWriter stdout;
    private final PrintWriter stderr;

    public static OutputModule system() {
        return new OutputModule(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public OutputModule(PrintWriter stdout, PrintWriter stderr) {
        this.stdout = (PrintWriter)Preconditions.checkNotNull((Object)stdout);
        this.stderr = (PrintWriter)Preconditions.checkNotNull((Object)stderr);
    }

    @Provides
    @Stdout
    PrintWriter provideStdoutWriter() {
        return this.stdout;
    }

    @Provides
    @Stderr
    PrintWriter provideStderr() {
        return this.stderr;
    }
}

