/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;

public final class Uuids {
    private static final int UUID_BYTES = 16;

    private Uuids() {
    }

    public static ByteBuffer toBytes(UUID uuid) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
        buf.flip();
        return buf;
    }

    public static void writeToChannel(UUID uuid, WritableByteChannel channel) throws IOException {
        ByteBuffer buf = Uuids.toBytes(uuid);
        while (buf.hasRemaining()) {
            channel.write(buf);
        }
    }

    public static UUID fromBytes(ByteBuffer buf) {
        Preconditions.checkArgument((buf.remaining() >= 16 ? 1 : 0) != 0);
        return new UUID(buf.getLong(), buf.getLong());
    }

    public static UUID readFromChannel(ReadableByteChannel channel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(16);
        while (buf.hasRemaining()) {
            if (channel.read(buf) != -1) continue;
            throw new EOFException("unexpected EOF while reading UUID");
        }
        buf.flip();
        return Uuids.fromBytes(buf);
    }
}

