/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.com.google.common.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.checkerframework.errorprone.checker.index.qual.LessThanBottom;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.SameLenBottom;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.signedness.qual.SignednessBottom;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.com.google.common.annotations.Beta;
import org.checkerframework.errorprone.com.google.common.base.Preconditions;
import org.checkerframework.errorprone.common.value.qual.BottomVal;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

@Beta
public final class Reflection {
    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness String getPackageName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Class<@SubstringIndexUnknown @SubstringIndexBottom @UnknownVal @BottomVal @SearchIndexUnknown @SearchIndexBottom @SameLenUnknown @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundUnknown @LowerBoundBottom @UpperBoundUnknown @UpperBoundBottom @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownSignedness @SignednessBottom ?> clazz) {
        return Reflection.getPackageName(clazz.getName());
    }

    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness String getPackageName(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness String classFullName) {
        int lastDot = classFullName.lastIndexOf(46);
        return lastDot < 0 ? "" : classFullName.substring(0, lastDot);
    }

    public static void initialize(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static <T> T newProxy(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Class<T> interfaceType, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness InvocationHandler handler) {
        Preconditions.checkNotNull(handler);
        Preconditions.checkArgument(interfaceType.isInterface(), "%s is not an interface", interfaceType);
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }

    private Reflection() {
    }
}

