/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.core.Running;
import com.google.caliper.worker.Allocation;
import com.google.caliper.worker.AllocationRecorder;
import com.google.caliper.worker.AllocationStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import com.google.monitoring.runtime.instrumentation.Sampler;
import java.util.Arrays;
import javax.inject.Inject;

final class AllAllocationsRecorder
extends AllocationRecorder {
    private final Class<?> benchmarkClass;
    private final String benchmarkMethodName;
    private volatile boolean recording = false;
    private final ConcurrentHashMultiset<Allocation> allocations = ConcurrentHashMultiset.create();
    private final Sampler sampler = new Sampler(){

        public void sampleAllocation(int arrayCount, String desc, Object newObj, long size) {
            if (AllAllocationsRecorder.this.recording) {
                StackTraceElement element;
                if (arrayCount != -1) {
                    String string = desc;
                    desc = new StringBuilder(13 + String.valueOf(string).length()).append(string).append("[").append(arrayCount).append("]").toString();
                }
                StackTraceElement[] stackTrace = new Exception().getStackTrace();
                int startIndex = 2;
                int endIndex = 2;
                for (int i = startIndex; i < stackTrace.length && !(element = stackTrace[i]).getClassName().startsWith(AllAllocationsRecorder.class.getPackage().getName()); ++i) {
                    endIndex = i;
                    if (element.getClassName().equals(AllAllocationsRecorder.this.benchmarkClass.getName()) && element.getMethodName().equals(AllAllocationsRecorder.this.benchmarkMethodName)) break;
                }
                AllAllocationsRecorder.this.allocations.add((Object)new Allocation(desc, size, Arrays.asList(stackTrace).subList(startIndex, endIndex + 1)));
            }
        }
    };

    @Inject
    AllAllocationsRecorder(@Running.BenchmarkClass Class<?> benchmarkClass, @Running.BenchmarkMethod String benchmarkMethodName) {
        this.benchmarkClass = benchmarkClass;
        this.benchmarkMethodName = benchmarkMethodName;
        com.google.monitoring.runtime.instrumentation.AllocationRecorder.addSampler((Sampler)this.sampler);
    }

    @Override
    protected void doStartRecording() {
        Preconditions.checkState((!this.recording ? 1 : 0) != 0, (Object)"startRecording called, but we were already recording.");
        this.allocations.clear();
        this.recording = true;
    }

    @Override
    public AllocationStats stopRecording(int reps) {
        Preconditions.checkState((boolean)this.recording, (Object)"stopRecording called, but we were not recording.");
        this.recording = false;
        return new AllocationStats((Multiset<Allocation>)this.allocations, reps);
    }
}

