/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.bridge.DryRunRequest;
import com.google.caliper.bridge.ExperimentSpec;
import com.google.caliper.bridge.TargetInfoRequest;
import com.google.caliper.bridge.TrialRequest;
import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.InstrumentType;
import com.google.caliper.worker.AggregateAllocationsRecorder;
import com.google.caliper.worker.AggregateAllocationsRecorder_Factory;
import com.google.caliper.worker.AllAllocationsRecorder;
import com.google.caliper.worker.AllAllocationsRecorder_Factory;
import com.google.caliper.worker.AllocationRecorder;
import com.google.caliper.worker.JvmWorkerInstrumentComponent;
import com.google.caliper.worker.JvmWorkerInstrumentModule_ProvideAllocationRecorderFactory;
import com.google.caliper.worker.MacrobenchmarkAllocationWorkerInstrument;
import com.google.caliper.worker.MacrobenchmarkAllocationWorkerInstrument_Factory;
import com.google.caliper.worker.MicrobenchmarkAllocationWorkerInstrument;
import com.google.caliper.worker.MicrobenchmarkAllocationWorkerInstrument_Factory;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerMain;
import com.google.caliper.worker.WorkerModule_ProvideAfterExperimentMethodsFactory;
import com.google.caliper.worker.WorkerModule_ProvideBeforeExperimentMethodsFactory;
import com.google.caliper.worker.WorkerModule_ProvideRandomFactory;
import com.google.caliper.worker.WorkerOptionsModule;
import com.google.caliper.worker.WorkerOptionsModule_BenchmarkClassFactory;
import com.google.caliper.worker.WorkerOptionsModule_ClientAddressFactory;
import com.google.caliper.worker.WorkerOptionsModule_IdFactory;
import com.google.caliper.worker.connection.ClientConnectionService;
import com.google.caliper.worker.connection.ClientConnectionService_Factory;
import com.google.caliper.worker.handler.DryRunHandler_Factory;
import com.google.caliper.worker.handler.RequestDispatcher;
import com.google.caliper.worker.handler.RequestDispatcher_Factory;
import com.google.caliper.worker.handler.TargetInfoHandler_Factory;
import com.google.caliper.worker.handler.TrialHandler_Factory;
import com.google.caliper.worker.instrument.ArbitraryMeasurementWorkerInstrument_Factory;
import com.google.caliper.worker.instrument.BenchmarkCreator_Factory;
import com.google.caliper.worker.instrument.MacrobenchmarkWorkerInstrument_Factory;
import com.google.caliper.worker.instrument.RuntimeWorkerInstrument_Micro_Factory;
import com.google.caliper.worker.instrument.RuntimeWorkerInstrument_Pico_Factory;
import com.google.caliper.worker.instrument.WorkerInstrument;
import com.google.caliper.worker.instrument.WorkerInstrumentFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentFactory_Factory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideBenchmarkInstanceFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideBenchmarkMethodFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideBenchmarkMethodNameFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideBenchmarkSpecFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideInstrumentTypeFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideTickerFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideUserParametersFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideWorkerInstrumentFactory;
import com.google.caliper.worker.instrument.WorkerInstrumentModule_ProvideWorkerInstrumentOptionsFactory;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.SingleCheck;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.inject.Provider;

public final class DaggerWorkerMain
extends WorkerMain {
    private Provider<UUID> idProvider;
    private Provider<InetSocketAddress> clientAddressProvider;
    private Provider<ClientConnectionService> clientConnectionServiceProvider;
    private Provider<Class<?>> benchmarkClassProvider;
    private Provider targetInfoHandlerProvider;
    private Provider<JvmWorkerInstrumentComponent.Builder> jvmWorkerInstrumentComponentBuilderProvider;
    private Provider<WorkerInstrumentFactory> workerInstrumentFactoryProvider;
    private Provider dryRunHandlerProvider;
    private Provider trialHandlerProvider;
    private Provider<Random> provideRandomProvider;

    private DaggerWorkerMain(WorkerOptionsModule workerOptionsModuleParam) {
        this.initialize(workerOptionsModuleParam);
    }

    public static WorkerMain.Builder builder() {
        return new Builder();
    }

    private Map getMapOfClassOfAndProviderOfRequestHandler() {
        return ImmutableMap.of(TargetInfoRequest.class, (Object)this.targetInfoHandlerProvider, DryRunRequest.class, (Object)this.dryRunHandlerProvider, TrialRequest.class, (Object)this.trialHandlerProvider);
    }

    private RequestDispatcher getRequestDispatcher() {
        return RequestDispatcher_Factory.newInstance((Map)this.getMapOfClassOfAndProviderOfRequestHandler());
    }

    private void initialize(WorkerOptionsModule workerOptionsModuleParam) {
        this.idProvider = WorkerOptionsModule_IdFactory.create((WorkerOptionsModule)workerOptionsModuleParam);
        this.clientAddressProvider = WorkerOptionsModule_ClientAddressFactory.create((WorkerOptionsModule)workerOptionsModuleParam);
        this.clientConnectionServiceProvider = DoubleCheck.provider((Provider)ClientConnectionService_Factory.create(this.idProvider, this.clientAddressProvider));
        this.benchmarkClassProvider = SingleCheck.provider((Provider)WorkerOptionsModule_BenchmarkClassFactory.create((WorkerOptionsModule)workerOptionsModuleParam));
        this.targetInfoHandlerProvider = TargetInfoHandler_Factory.create(this.clientConnectionServiceProvider, this.benchmarkClassProvider);
        this.jvmWorkerInstrumentComponentBuilderProvider = new Provider<JvmWorkerInstrumentComponent.Builder>(){

            public JvmWorkerInstrumentComponent.Builder get() {
                return new JvmWorkerInstrumentComponentBuilder();
            }
        };
        this.workerInstrumentFactoryProvider = WorkerInstrumentFactory_Factory.create(this.jvmWorkerInstrumentComponentBuilderProvider);
        this.dryRunHandlerProvider = DryRunHandler_Factory.create(this.clientConnectionServiceProvider, this.workerInstrumentFactoryProvider);
        this.trialHandlerProvider = TrialHandler_Factory.create(this.clientConnectionServiceProvider, this.workerInstrumentFactoryProvider);
        this.provideRandomProvider = DoubleCheck.provider((Provider)WorkerModule_ProvideRandomFactory.create());
    }

    public Worker worker() {
        return new Worker((ClientConnectionService)this.clientConnectionServiceProvider.get(), this.getRequestDispatcher());
    }

    private final class JvmWorkerInstrumentComponentImpl
    implements JvmWorkerInstrumentComponent {
        private final ExperimentSpec experiment;
        private Provider<ExperimentSpec> experimentProvider;
        private Provider<BenchmarkSpec> provideBenchmarkSpecProvider;
        private Provider<ImmutableSortedMap<String, String>> provideUserParametersProvider;
        private Provider benchmarkCreatorProvider;
        private Provider<Object> provideBenchmarkInstanceProvider;
        private Provider<Method> provideBenchmarkMethodProvider;
        private Provider<Map<String, String>> provideWorkerInstrumentOptionsProvider;
        private Provider<ImmutableSet<Method>> provideBeforeExperimentMethodsProvider;
        private Provider<ImmutableSet<Method>> provideAfterExperimentMethodsProvider;
        private Provider arbitraryMeasurementWorkerInstrumentProvider;
        private Provider macrobenchmarkWorkerInstrumentProvider;
        private Provider microProvider;
        private Provider picoProvider;
        private Provider<String> provideBenchmarkMethodNameProvider;
        private Provider<AllAllocationsRecorder> allAllocationsRecorderProvider;
        private Provider<AllocationRecorder> provideAllocationRecorderProvider;
        private Provider<MicrobenchmarkAllocationWorkerInstrument> microbenchmarkAllocationWorkerInstrumentProvider;
        private Provider<MacrobenchmarkAllocationWorkerInstrument> macrobenchmarkAllocationWorkerInstrumentProvider;

        private JvmWorkerInstrumentComponentImpl(ExperimentSpec experimentParam) {
            this.experiment = experimentParam;
            this.initialize(experimentParam);
        }

        private InstrumentType getInstrumentType() {
            return WorkerInstrumentModule_ProvideInstrumentTypeFactory.provideInstrumentType((ExperimentSpec)this.experiment);
        }

        private Map<InstrumentType, Provider<WorkerInstrument>> getMapOfInstrumentTypeAndProviderOfWorkerInstrument() {
            return ImmutableMap.builderWithExpectedSize((int)6).put((Object)InstrumentType.ARBITRARY_MEASUREMENT, (Object)this.arbitraryMeasurementWorkerInstrumentProvider).put((Object)InstrumentType.RUNTIME_MACRO, (Object)this.macrobenchmarkWorkerInstrumentProvider).put((Object)InstrumentType.RUNTIME_MICRO, (Object)this.microProvider).put((Object)InstrumentType.RUNTIME_PICO, (Object)this.picoProvider).put((Object)InstrumentType.ALLOCATION_MICRO, this.microbenchmarkAllocationWorkerInstrumentProvider).put((Object)InstrumentType.ALLOCATION_MACRO, this.macrobenchmarkAllocationWorkerInstrumentProvider).build();
        }

        private void initialize(ExperimentSpec experimentParam) {
            this.experimentProvider = InstanceFactory.create((Object)experimentParam);
            this.provideBenchmarkSpecProvider = WorkerInstrumentModule_ProvideBenchmarkSpecFactory.create(this.experimentProvider);
            this.provideUserParametersProvider = WorkerInstrumentModule_ProvideUserParametersFactory.create(this.provideBenchmarkSpecProvider);
            this.benchmarkCreatorProvider = BenchmarkCreator_Factory.create((Provider)DaggerWorkerMain.this.benchmarkClassProvider, this.provideUserParametersProvider);
            this.provideBenchmarkInstanceProvider = WorkerInstrumentModule_ProvideBenchmarkInstanceFactory.create((Provider)this.benchmarkCreatorProvider);
            this.provideBenchmarkMethodProvider = SingleCheck.provider((Provider)WorkerInstrumentModule_ProvideBenchmarkMethodFactory.create(this.experimentProvider, this.provideBenchmarkSpecProvider, (Provider)DaggerWorkerMain.this.benchmarkClassProvider));
            this.provideWorkerInstrumentOptionsProvider = WorkerInstrumentModule_ProvideWorkerInstrumentOptionsFactory.create(this.experimentProvider);
            this.provideBeforeExperimentMethodsProvider = SingleCheck.provider((Provider)WorkerModule_ProvideBeforeExperimentMethodsFactory.create((Provider)DaggerWorkerMain.this.benchmarkClassProvider));
            this.provideAfterExperimentMethodsProvider = SingleCheck.provider((Provider)WorkerModule_ProvideAfterExperimentMethodsFactory.create((Provider)DaggerWorkerMain.this.benchmarkClassProvider));
            this.arbitraryMeasurementWorkerInstrumentProvider = ArbitraryMeasurementWorkerInstrument_Factory.create(this.provideBenchmarkInstanceProvider, this.provideBenchmarkMethodProvider, this.provideWorkerInstrumentOptionsProvider, this.provideBeforeExperimentMethodsProvider, this.provideAfterExperimentMethodsProvider);
            this.macrobenchmarkWorkerInstrumentProvider = MacrobenchmarkWorkerInstrument_Factory.create(this.provideBenchmarkInstanceProvider, this.provideBenchmarkMethodProvider, (Provider)WorkerInstrumentModule_ProvideTickerFactory.create(), this.provideWorkerInstrumentOptionsProvider, this.provideBeforeExperimentMethodsProvider, this.provideAfterExperimentMethodsProvider);
            this.microProvider = RuntimeWorkerInstrument_Micro_Factory.create(this.provideBenchmarkInstanceProvider, this.provideBenchmarkMethodProvider, (Provider)DaggerWorkerMain.this.provideRandomProvider, (Provider)WorkerInstrumentModule_ProvideTickerFactory.create(), this.provideWorkerInstrumentOptionsProvider, this.provideBeforeExperimentMethodsProvider, this.provideAfterExperimentMethodsProvider);
            this.picoProvider = RuntimeWorkerInstrument_Pico_Factory.create(this.provideBenchmarkInstanceProvider, this.provideBenchmarkMethodProvider, (Provider)DaggerWorkerMain.this.provideRandomProvider, (Provider)WorkerInstrumentModule_ProvideTickerFactory.create(), this.provideWorkerInstrumentOptionsProvider, this.provideBeforeExperimentMethodsProvider, this.provideAfterExperimentMethodsProvider);
            this.provideBenchmarkMethodNameProvider = WorkerInstrumentModule_ProvideBenchmarkMethodNameFactory.create(this.provideBenchmarkMethodProvider);
            this.allAllocationsRecorderProvider = AllAllocationsRecorder_Factory.create(DaggerWorkerMain.this.benchmarkClassProvider, this.provideBenchmarkMethodNameProvider);
            this.provideAllocationRecorderProvider = JvmWorkerInstrumentModule_ProvideAllocationRecorderFactory.create(this.provideWorkerInstrumentOptionsProvider, this.allAllocationsRecorderProvider, (Provider<AggregateAllocationsRecorder>)AggregateAllocationsRecorder_Factory.create());
            this.microbenchmarkAllocationWorkerInstrumentProvider = MicrobenchmarkAllocationWorkerInstrument_Factory.create(this.provideBenchmarkInstanceProvider, this.provideBenchmarkMethodProvider, this.provideAllocationRecorderProvider, (Provider<Random>)DaggerWorkerMain.this.provideRandomProvider, this.provideBeforeExperimentMethodsProvider, this.provideAfterExperimentMethodsProvider);
            this.macrobenchmarkAllocationWorkerInstrumentProvider = MacrobenchmarkAllocationWorkerInstrument_Factory.create(this.provideBenchmarkInstanceProvider, this.provideBenchmarkMethodProvider, this.provideAllocationRecorderProvider, this.provideBeforeExperimentMethodsProvider, this.provideAfterExperimentMethodsProvider);
        }

        public WorkerInstrument instrument() {
            return WorkerInstrumentModule_ProvideWorkerInstrumentFactory.provideWorkerInstrument((InstrumentType)this.getInstrumentType(), this.getMapOfInstrumentTypeAndProviderOfWorkerInstrument());
        }
    }

    private final class JvmWorkerInstrumentComponentBuilder
    implements JvmWorkerInstrumentComponent.Builder {
        private ExperimentSpec experiment;

        private JvmWorkerInstrumentComponentBuilder() {
        }

        public JvmWorkerInstrumentComponentBuilder experiment(ExperimentSpec arg0) {
            this.experiment = (ExperimentSpec)Preconditions.checkNotNull((Object)arg0);
            return this;
        }

        public JvmWorkerInstrumentComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.experiment, ExperimentSpec.class);
            return new JvmWorkerInstrumentComponentImpl(this.experiment);
        }
    }

    private static final class Builder
    implements WorkerMain.Builder {
        private WorkerOptionsModule workerOptionsModule;

        private Builder() {
        }

        public Builder options(WorkerOptionsModule arg0) {
            this.workerOptionsModule = (WorkerOptionsModule)Preconditions.checkNotNull((Object)arg0);
            return this;
        }

        @Override
        public WorkerMain build() {
            Preconditions.checkBuilderRequirement((Object)this.workerOptionsModule, WorkerOptionsModule.class);
            return new DaggerWorkerMain(this.workerOptionsModule);
        }
    }
}

