/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class CodeAttribute
extends Attribute {
    private static final byte[] EMPTY_CODE = new byte[0];
    private static final ExceptionInfo[] EMPTY_EXCEPTION_TABLE = new ExceptionInfo[0];
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    public int u2maxStack;
    public int u2maxLocals;
    public int u4codeLength;
    public byte[] code;
    public int u2exceptionTableLength;
    public ExceptionInfo[] exceptionTable;
    public int u2attributesCount;
    public Attribute[] attributes;

    public CodeAttribute() {
    }

    public CodeAttribute(int u2attributeNameIndex) {
        this(u2attributeNameIndex, 0, 0, 0, EMPTY_CODE);
    }

    public CodeAttribute(int u2attributeNameIndex, int u2maxStack, int u2maxLocals, int u4codeLength, byte[] code) {
        this(u2attributeNameIndex, u2maxStack, u2maxLocals, u4codeLength, code, 0, EMPTY_EXCEPTION_TABLE, 0, EMPTY_ATTRIBUTES);
    }

    public CodeAttribute(int u2attributeNameIndex, int u2maxStack, int u2maxLocals, int u4codeLength, byte[] code, int u2exceptionTableLength, ExceptionInfo[] exceptionTable, int u2attributesCount, Attribute[] attributes) {
        super(u2attributeNameIndex);
        this.u2maxStack = u2maxStack;
        this.u2maxLocals = u2maxLocals;
        this.u4codeLength = u4codeLength;
        this.code = code;
        this.u2exceptionTableLength = u2exceptionTableLength;
        this.exceptionTable = exceptionTable;
        this.u2attributesCount = u2attributesCount;
        this.attributes = attributes;
    }

    public Attribute getAttribute(Clazz clazz, String name) {
        for (int index = 0; index < this.u2attributesCount; ++index) {
            Attribute attribute = this.attributes[index];
            if (!attribute.getAttributeName(clazz).equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void accept(Clazz clazz, Method method, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitCodeAttribute(clazz, method, this);
    }

    public void instructionsAccept(Clazz clazz, Method method, InstructionVisitor instructionVisitor) {
        this.instructionsAccept(clazz, method, 0, this.u4codeLength, instructionVisitor);
    }

    public void instructionAccept(Clazz clazz, Method method, int offset, InstructionVisitor instructionVisitor) {
        Instruction instruction = InstructionFactory.create(this.code, offset);
        instruction.accept(clazz, method, this, offset, instructionVisitor);
    }

    public void instructionsAccept(Clazz clazz, Method method, int startOffset, int endOffset, InstructionVisitor instructionVisitor) {
        int instructionLength;
        for (int offset = startOffset; offset < endOffset; offset += instructionLength) {
            Instruction instruction = InstructionFactory.create(this.code, offset);
            instructionLength = instruction.length(offset);
            instruction.accept(clazz, method, this, offset, instructionVisitor);
        }
    }

    public void exceptionsAccept(Clazz clazz, Method method, ExceptionInfoVisitor exceptionInfoVisitor) {
        for (int index = 0; index < this.u2exceptionTableLength; ++index) {
            exceptionInfoVisitor.visitExceptionInfo(clazz, method, this, this.exceptionTable[index]);
        }
    }

    public void exceptionsAccept(Clazz clazz, Method method, int offset, ExceptionInfoVisitor exceptionInfoVisitor) {
        for (int index = 0; index < this.u2exceptionTableLength; ++index) {
            ExceptionInfo exceptionInfo = this.exceptionTable[index];
            if (!exceptionInfo.isApplicable(offset)) continue;
            exceptionInfoVisitor.visitExceptionInfo(clazz, method, this, exceptionInfo);
        }
    }

    public void exceptionsAccept(Clazz clazz, Method method, int startOffset, int endOffset, ExceptionInfoVisitor exceptionInfoVisitor) {
        for (int index = 0; index < this.u2exceptionTableLength; ++index) {
            ExceptionInfo exceptionInfo = this.exceptionTable[index];
            if (!exceptionInfo.isApplicable(startOffset, endOffset)) continue;
            exceptionInfoVisitor.visitExceptionInfo(clazz, method, this, exceptionInfo);
        }
    }

    public void attributesAccept(Clazz clazz, Method method, AttributeVisitor attributeVisitor) {
        for (int index = 0; index < this.u2attributesCount; ++index) {
            this.attributes[index].accept(clazz, method, this, attributeVisitor);
        }
    }
}

