/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.instrument;

import com.google.caliper.Benchmark;
import com.google.caliper.api.Macrobenchmark;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.model.InstrumentType;
import com.google.caliper.runner.config.SupportsVmType;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.instrument.BenchmarkMethods;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.instrument.JarFinder;
import com.google.caliper.runner.instrument.MeasurementCollectingVisitor;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

@SupportsVmType(value={VmType.JVM})
public final class AllocationInstrument
extends Instrument {
    private static final String ALLOCATION_AGENT_JAR_OPTION = "allocationAgentJar";
    private static final String TRACK_ALLOCATIONS_OPTION = "trackAllocations";
    private static final ImmutableSet<String> ALLOCATION_INSTRUMENTER_PREMAIN_CLASS_NAMES = ImmutableSet.of((Object)"com.google.monitoring.runtime.instrumentation.AllocationInstrumenter", (Object)"com.google.monitoring.runtime.instrumentation.AllocationInstrumenterBootstrap");
    private static final Logger logger = Logger.getLogger(AllocationInstrument.class.getName());

    public boolean isBenchmarkMethod(BenchmarkClassModel.MethodModel method) {
        return method.isAnnotationPresent(Benchmark.class) || BenchmarkMethods.isTimeMethod((BenchmarkClassModel.MethodModel)method) || method.isAnnotationPresent(Macrobenchmark.class);
    }

    public Instrument.InstrumentedMethod createInstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) throws InvalidBenchmarkException {
        Preconditions.checkNotNull((Object)benchmarkMethod);
        Preconditions.checkArgument((boolean)this.isBenchmarkMethod(benchmarkMethod));
        try {
            switch (BenchmarkMethods.Type.of((BenchmarkClassModel.MethodModel)benchmarkMethod)) {
                case MACRO: {
                    return new MacroAllocationInstrumentedMethod(benchmarkMethod);
                }
                case MICRO: 
                case PICO: {
                    return new MicroAllocationInstrumentedMethod(benchmarkMethod);
                }
            }
            throw new AssertionError((Object)"unknown type");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBenchmarkException("Benchmark methods must have no arguments or accept a single int or long parameter: %s", new Object[]{benchmarkMethod.name()});
        }
    }

    public boolean parallelizable() {
        return true;
    }

    public ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)ALLOCATION_AGENT_JAR_OPTION, (Object)TRACK_ALLOCATIONS_OPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<File> findAllocationInstrumentJarOnClasspath() throws IOException {
        ImmutableSet<File> jarFiles = JarFinder.findJarFiles(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader());
        for (File file : jarFiles) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || !ALLOCATION_INSTRUMENTER_PREMAIN_CLASS_NAMES.contains((Object)manifest.getMainAttributes().getValue("Premain-Class"))) continue;
                Optional optional = Optional.of((Object)file);
                return optional;
            }
            finally {
                if (jarFile == null) continue;
                jarFile.close();
            }
        }
        return Optional.absent();
    }

    public ImmutableSet<String> getExtraCommandLineArgs(VmConfig vmConfig) {
        String agentJar = (String)this.options.get((Object)ALLOCATION_AGENT_JAR_OPTION);
        if (Strings.isNullOrEmpty((String)agentJar)) {
            try {
                Optional<File> instrumentJar = AllocationInstrument.findAllocationInstrumentJarOnClasspath();
                if (instrumentJar.isPresent()) {
                    agentJar = ((File)instrumentJar.get()).getAbsolutePath();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "An exception occurred trying to locate the allocation agent jar on the classpath", e);
            }
        }
        if (Strings.isNullOrEmpty((String)agentJar) || !new File(agentJar).exists()) {
            throw new IllegalStateException("Can't find required allocationinstrumenter agent jar");
        }
        String string = String.valueOf(agentJar);
        String string2 = String.valueOf(agentJar);
        return new ImmutableSet.Builder().add((Object)"-Xint").add((Object)(string.length() != 0 ? "-javaagent:".concat(string) : new String("-javaagent:"))).add((Object)(string2.length() != 0 ? "-Xbootclasspath/a:".concat(string2) : new String("-Xbootclasspath/a:"))).build();
    }

    private final class MacroAllocationInstrumentedMethod
    extends Instrument.InstrumentedMethod {
        MacroAllocationInstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) {
            super((Instrument)AllocationInstrument.this, benchmarkMethod);
        }

        public ImmutableMap<String, String> workerOptions() {
            return ImmutableMap.of((Object)AllocationInstrument.TRACK_ALLOCATIONS_OPTION, (Object)((String)AllocationInstrument.this.options.get((Object)AllocationInstrument.TRACK_ALLOCATIONS_OPTION)));
        }

        public InstrumentType type() {
            return InstrumentType.ALLOCATION_MACRO;
        }

        public MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new Instrument.DefaultMeasurementCollectingVisitor(ImmutableSet.of((Object)"bytes", (Object)"objects"));
        }
    }

    private final class MicroAllocationInstrumentedMethod
    extends Instrument.InstrumentedMethod {
        MicroAllocationInstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) {
            super((Instrument)AllocationInstrument.this, benchmarkMethod);
        }

        public ImmutableMap<String, String> workerOptions() {
            return ImmutableMap.of((Object)AllocationInstrument.TRACK_ALLOCATIONS_OPTION, (Object)((String)AllocationInstrument.this.options.get((Object)AllocationInstrument.TRACK_ALLOCATIONS_OPTION)));
        }

        public InstrumentType type() {
            return InstrumentType.ALLOCATION_MICRO;
        }

        public MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new Instrument.DefaultMeasurementCollectingVisitor(ImmutableSet.of((Object)"bytes", (Object)"objects"));
        }
    }
}

