/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.resultprocessor;

import com.google.caliper.model.Trial;
import com.google.caliper.runner.resultprocessor.ResultsUploader;
import com.google.common.base.Optional;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.UUID;

final class JacksonUploadHandler
implements ResultsUploader.UploadHandler {
    private final Client client;

    JacksonUploadHandler(Client client) {
        this.client = client;
    }

    public boolean upload(URI uri, String content, String mediaType, Optional<UUID> apiKey, Trial trial) {
        WebResource resource = this.client.resource(uri);
        if (apiKey.isPresent()) {
            resource = resource.queryParam("key", ((UUID)apiKey.get()).toString());
        }
        try {
            resource.type(mediaType).post((Object)content);
            return true;
        }
        catch (ClientHandlerException e) {
            ResultsUploader.logUploadFailure((Trial)trial, (Exception)((Object)e));
        }
        catch (UniformInterfaceException e) {
            ResultsUploader.logUploadFailure((Trial)trial, (Exception)((Object)e));
            int n = e.getResponse().getStatus();
            ResultsUploader.logger.fine(new StringBuilder(35).append("Failed upload response: ").append(n).toString());
        }
        return false;
    }
}

