/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.DuplicateClassPrinter;
import proguard.DuplicateResourceFilePrinter;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.io.ClassFilter;
import proguard.io.ClassReader;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.DirectorySource;
import proguard.io.NameFilteredDataEntryReader;
import proguard.pass.Pass;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.io.ResourceFileDataEntryReader;
import proguard.resources.file.visitor.MultiResourceFileVisitor;
import proguard.resources.file.visitor.ResourceFilePoolFiller;
import proguard.resources.file.visitor.ResourceFilePresenceFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.io.KotlinModuleDataEntryReader;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringParser;

public class InputReader
implements Pass {
    private static final Logger logger = LogManager.getLogger(InputReader.class);
    private static final boolean DONT_READ_LIBRARY_KOTLIN_METADATA = System.getProperty("proguard.dontreadlibrarykotlinmetadata") != null;
    private final Configuration configuration;
    private String featureName;

    public InputReader(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws IOException {
        int warningCount;
        int noteCount;
        logger.info("Reading input...");
        WarningLogger notePrinter = new WarningLogger(logger, this.configuration.note);
        WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
        DuplicateClassPrinter duplicateClassPrinter = new DuplicateClassPrinter((WarningPrinter)notePrinter);
        DuplicateResourceFilePrinter duplicateResourceFilePrinter = new DuplicateResourceFilePrinter((WarningPrinter)notePrinter);
        ClassPresenceFilter classPoolFiller = new ClassPresenceFilter(appView.programClassPool, (ClassVisitor)duplicateClassPrinter, (ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassPoolFiller(appView.programClassPool), new ProgramClassFilter(clazz -> clazz.setFeatureName(this.featureName))}));
        ClassReader classReader = new ClassReader(false, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate, this.configuration.keepKotlinMetadata, (WarningPrinter)warningPrinter, (ClassVisitor)classPoolFiller);
        DataEntryNameFilter adaptedDataEntryFilter = this.configuration.adaptResourceFileContents != null ? new DataEntryNameFilter(new ListParser((StringParser)new FileNameParser()).parse(this.configuration.adaptResourceFileContents)) : null;
        ResourceFilePresenceFilter resourceFilePoolFiller = new ResourceFilePresenceFilter(appView.resourceFilePool, (ResourceFileVisitor)duplicateResourceFilePrinter, (ResourceFileVisitor)new MultiResourceFileVisitor(new ResourceFileVisitor[]{new ResourceFilePoolFiller(appView.resourceFilePool), new MyResourceFileFeatureNameSetter()}));
        ResourceFileDataEntryReader resourceReader = new ResourceFileDataEntryReader((ResourceFileVisitor)resourceFilePoolFiller, (DataEntryFilter)adaptedDataEntryFilter);
        if (this.configuration.keepKotlinMetadata) {
            resourceReader = new NameFilteredDataEntryReader("META-INF/*.kotlin_module", (DataEntryReader)new KotlinModuleDataEntryReader((ResourceFileVisitor)resourceFilePoolFiller), (DataEntryReader)resourceReader);
        }
        this.readInput("Reading program ", this.configuration.programJars, (DataEntryReader)new ClassFilter((DataEntryReader)classReader, (DataEntryReader)resourceReader));
        if (appView.programClassPool.size() == 0) {
            throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null && (this.configuration.printSeeds != null || this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify || this.configuration.backport)) {
            this.readInput("Reading library ", this.configuration.libraryJars, (DataEntryReader)new ClassFilter((DataEntryReader)new ClassReader(true, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, true, !DONT_READ_LIBRARY_KOTLIN_METADATA && this.configuration.keepKotlinMetadata, (WarningPrinter)warningPrinter, (ClassVisitor)new ClassPresenceFilter(appView.programClassPool, (ClassVisitor)duplicateClassPrinter, (ClassVisitor)new ClassPresenceFilter(appView.libraryClassPool, (ClassVisitor)duplicateClassPrinter, (ClassVisitor)new ClassPoolFiller(appView.libraryClassPool))))));
        }
        if ((noteCount = notePrinter.getWarningCount()) > 0) {
            logger.warn("Note: there were {} duplicate class definitions.", (Object)noteCount);
            logger.warn("      (https://www.guardsquare.com/proguard/manual/troubleshooting#duplicateclass)");
        }
        if ((warningCount = warningPrinter.getWarningCount()) > 0) {
            logger.warn("Warning: there were {} classes in incorrectly named files.", (Object)warningCount);
            logger.warn("         You should make sure all file names correspond to their class names.");
            logger.warn("         The directory hierarchies must correspond to the package hierarchies.");
            logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#unexpectedclass)");
            if (!this.configuration.ignoreWarnings) {
                logger.warn("         If you don't mind the mentioned classes not being written out,");
                logger.warn("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }

    private void readInput(String messagePrefix, ClassPath classPath, DataEntryReader reader) throws IOException {
        this.readInput(messagePrefix, classPath, 0, classPath.size(), reader);
    }

    public void readInput(String messagePrefix, ClassPath classPath, int fromIndex, int toIndex, DataEntryReader reader) throws IOException {
        for (int index = fromIndex; index < toIndex; ++index) {
            ClassPathEntry entry = classPath.get(index);
            if (entry.isOutput()) continue;
            this.readInput(messagePrefix, entry, reader);
        }
    }

    private void readInput(String messagePrefix, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            List<String> filter = DataEntryReaderFactory.getFilterExcludingVersionedClasses(classPathEntry);
            logger.info("{}{} [{}]{}", (Object)messagePrefix, (Object)(classPathEntry.isDex() ? "dex" : (classPathEntry.isApk() ? "apk" : (classPathEntry.isAab() ? "aab" : (classPathEntry.isJar() ? "jar" : (classPathEntry.isAar() ? "aar" : (classPathEntry.isWar() ? "war" : (classPathEntry.isEar() ? "ear" : (classPathEntry.isJmod() ? "jmod" : (classPathEntry.isZip() ? "zip" : "directory"))))))))), (Object)classPathEntry.getName(), (Object)(filter != null || classPathEntry.isFiltered() ? " (filtered)" : ""));
            DataEntryReader reader = new DataEntryReaderFactory(this.configuration.android).createDataEntryReader(classPathEntry, dataEntryReader);
            DirectorySource source = new DirectorySource(classPathEntry.getFile());
            this.featureName = classPathEntry.getFeatureName();
            source.pumpDataEntries(reader);
        }
        catch (IOException ex) {
            throw new IOException("Can't read [" + classPathEntry + "] (" + ex.getMessage() + ")", ex);
        }
    }

    private class MyResourceFileFeatureNameSetter
    implements ResourceFileVisitor {
        private MyResourceFileFeatureNameSetter() {
        }

        public void visitAnyResourceFile(ResourceFile resourceFile) {
            resourceFile.setFeatureName(InputReader.this.featureName);
        }
    }
}

