/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.DummyDataEntry;
import proguard.io.ExtraDataEntryNameMap;

public class ExtraDataEntryReader
implements DataEntryReader {
    private final ExtraDataEntryNameMap extraEntryNameMap;
    private final DataEntryReader dataEntryReader;
    private final DataEntryReader extraDataEntryReader;
    private final Set<String> extraEntryNamesRead = new HashSet<String>();

    public ExtraDataEntryReader(String extraEntryName, DataEntryReader dataEntryReader) {
        this(extraEntryName, dataEntryReader, dataEntryReader);
    }

    public ExtraDataEntryReader(String extraEntryName, DataEntryReader dataEntryReader, DataEntryReader extraDataEntryReader) {
        this(new ExtraDataEntryNameMap(), dataEntryReader, extraDataEntryReader);
        this.extraEntryNameMap.addExtraDataEntry(extraEntryName);
    }

    public ExtraDataEntryReader(ExtraDataEntryNameMap extraEntryNameMap, DataEntryReader dataEntryReader) {
        this(extraEntryNameMap, dataEntryReader, dataEntryReader);
    }

    public ExtraDataEntryReader(ExtraDataEntryNameMap extraEntryNameMap, DataEntryReader dataEntryReader, DataEntryReader extraDataEntryReader) {
        this.extraEntryNameMap = extraEntryNameMap;
        this.dataEntryReader = dataEntryReader;
        this.extraDataEntryReader = extraDataEntryReader;
    }

    public void read(DataEntry dataEntry) throws IOException {
        DataEntry parentEntry = dataEntry.getParent();
        this.readExtraEntries(parentEntry, this.extraEntryNameMap.getDefaultExtraDataEntryNames());
        this.readExtraEntries(parentEntry, this.extraEntryNameMap.getExtraDataEntryNames(dataEntry.getName()));
        this.dataEntryReader.read(dataEntry);
    }

    private void readExtraEntries(DataEntry parentEntry, Set<String> extraEntryNames) throws IOException {
        if (extraEntryNames != null) {
            for (String extraEntryName : extraEntryNames) {
                if (!this.extraEntryNamesRead.add(extraEntryName)) continue;
                DummyDataEntry extraEntry = new DummyDataEntry(parentEntry, extraEntryName, 0L, false);
                this.extraDataEntryReader.read((DataEntry)extraEntry);
                this.readExtraEntries(parentEntry, this.extraEntryNameMap.getExtraDataEntryNames(extraEntryName));
            }
        }
    }
}

