/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.ClassMemberPair;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.CalledMemberVisitor;
import proguard.optimize.ReverseDependencyStore;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.util.MultiValueMap;

public class ReverseDependencyCalculator {
    private static final Logger logger = LogManager.getFormatterLogger(ReverseDependencyCalculator.class);
    private final ClassPool classPool;

    public ReverseDependencyCalculator(ClassPool classPool) {
        this.classPool = classPool;
    }

    public ReverseDependencyStore reverseDependencyStore() {
        long start = System.currentTimeMillis();
        ReverseDependencyStore out = new ReverseDependencyStore(this.isCalledBy(), this.methodsByProgramMethodOptimizationInfo());
        long end = System.currentTimeMillis();
        logger.trace("Calculating Reverse Dependencies................ took: %6d ms", (Object)(end - start));
        return out;
    }

    private MultiValueMap<Method, ClassMemberPair> isCalledBy() {
        MultiValueMap isCalledBy = new MultiValueMap();
        this.classPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new AddDependencies((MultiValueMap<Method, ClassMemberPair>)isCalledBy)));
        return isCalledBy;
    }

    private MultiValueMap<ProgramMethodOptimizationInfo, Method> methodsByProgramMethodOptimizationInfo() {
        MultiValueMap map = new MultiValueMap();
        this.classPool.classesAccept((ClassVisitor)new AllMethodVisitor((MemberVisitor)new FillMethodsByProgramMethodOptimizationInfo((MultiValueMap<ProgramMethodOptimizationInfo, Method>)map)));
        return map;
    }

    private static class AddDependencies
    implements MemberVisitor {
        private final MultiValueMap<Method, ClassMemberPair> isCalledBy;

        AddDependencies(MultiValueMap<Method, ClassMemberPair> isCalledBy) {
            this.isCalledBy = isCalledBy;
        }

        public void visitAnyMember(Clazz clazz, Member member) {
            member.accept(clazz, (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)new AllInstructionVisitor((InstructionVisitor)new CalledMemberVisitor(new Adder(new ClassMemberPair(clazz, member))))));
        }

        private class Adder
        implements MemberVisitor {
            private final ClassMemberPair source;

            Adder(ClassMemberPair source) {
                this.source = source;
            }

            public void visitAnyMember(Clazz clazz, Member member) {
            }

            public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                AddDependencies.this.isCalledBy.put((Object)programMethod, (Object)this.source);
            }
        }
    }

    private static class FillMethodsByProgramMethodOptimizationInfo
    implements MemberVisitor {
        private final MultiValueMap<ProgramMethodOptimizationInfo, Method> map;

        public FillMethodsByProgramMethodOptimizationInfo(MultiValueMap<ProgramMethodOptimizationInfo, Method> map) {
            this.map = map;
        }

        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo((Method)programMethod);
            if (methodOptimizationInfo instanceof ProgramMethodOptimizationInfo) {
                this.map.put((Object)((ProgramMethodOptimizationInfo)methodOptimizationInfo), (Object)programMethod);
            }
        }

        public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        }

        public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        }
    }
}

