/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberToClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumClassChecker
implements ClassVisitor {
    private static final Logger logger = LogManager.getLogger(SimpleEnumClassChecker.class);
    private final ClassVisitor simpleEnumMarker = new OptimizationInfoClassFilter(new SimpleEnumMarker(true));
    private final MemberVisitor instanceMemberChecker = new MemberAccessFilter(0, 8, (MemberVisitor)new MemberToClassVisitor((ClassVisitor)new SimpleEnumMarker(false)));

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        Method simpleEnumConstructor = programClass.findMethod("<init>", "(Ljava/lang/String;I)V");
        if (simpleEnumConstructor == null) {
            return;
        }
        logger.debug("SimpleEnumClassChecker: [{}] is a candidate simple enum, without extra fields", (Object)programClass.getName());
        this.simpleEnumMarker.visitProgramClass(programClass);
        programClass.fieldsAccept(this.instanceMemberChecker);
        programClass.methodsAccept((MemberVisitor)new MemberCollectionFilter(Collections.singleton(simpleEnumConstructor), null, this.instanceMemberChecker));
    }

    private static class MemberCollectionFilter
    implements MemberVisitor {
        private final Set<Member> members;
        private final MemberVisitor acceptedVisitor;
        private final MemberVisitor rejectedVisitor;

        public MemberCollectionFilter(Set<Member> members, MemberVisitor acceptedVisitor) {
            this(members, acceptedVisitor, null);
        }

        public MemberCollectionFilter(Set<Member> members, MemberVisitor acceptedVisitor, MemberVisitor rejectedVisitor) {
            this.members = members;
            this.acceptedVisitor = acceptedVisitor;
            this.rejectedVisitor = rejectedVisitor;
        }

        public void visitAnyMember(Clazz clazz, Member member) {
            MemberVisitor delegateVisitor = this.delegateVisitor(member);
            if (delegateVisitor != null) {
                member.accept(clazz, delegateVisitor);
            }
        }

        private MemberVisitor delegateVisitor(Member member) {
            return this.members.contains(member) ? this.acceptedVisitor : this.rejectedVisitor;
        }
    }
}

