/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ParameterAnnotationsAttributeEditor;

class MarkedAnnotationDeleter
implements AttributeVisitor {
    private final Object mark;

    public MarkedAnnotationDeleter(Object mark) {
        this.mark = mark;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Member member, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, (AnnotationsAttribute)runtimeVisibleAnnotationsAttribute, "RuntimeVisibleAnnotations");
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Member member, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, (AnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, "RuntimeInvisibleAnnotations");
    }

    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        this.cleanParameterAnnotationsAttribute(clazz, (Member)method, (ParameterAnnotationsAttribute)runtimeVisibleParameterAnnotationsAttribute, "RuntimeVisibleParameterAnnotations");
    }

    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        this.cleanParameterAnnotationsAttribute(clazz, (Member)method, (ParameterAnnotationsAttribute)runtimeInvisibleParameterAnnotationsAttribute, "RuntimeInvisibleParameterAnnotations");
    }

    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, Member member, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, (AnnotationsAttribute)runtimeVisibleTypeAnnotationsAttribute, "RuntimeVisibleTypeAnnotations");
    }

    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, Member member, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, (AnnotationsAttribute)runtimeInvisibleTypeAnnotationsAttribute, "RuntimeInvisibleTypeAnnotations");
    }

    private void cleanAnnotationsAttribute(Clazz clazz, Member member, AnnotationsAttribute attribute, String attributeName) {
        AnnotationsAttributeEditor annotationsAttributeEditor = new AnnotationsAttributeEditor(attribute);
        Annotation[] annotations = attribute.annotations;
        int index = 0;
        while (index < attribute.u2annotationsCount) {
            Annotation annotation = annotations[index];
            if (annotation.getProcessingInfo() == this.mark) {
                annotationsAttributeEditor.deleteAnnotation(index);
                continue;
            }
            ++index;
        }
        if (attribute.u2annotationsCount == 0) {
            AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)member, false);
            attributesEditor.deleteAttribute(attributeName);
        }
    }

    private void cleanParameterAnnotationsAttribute(Clazz clazz, Member member, ParameterAnnotationsAttribute attribute, String attributeName) {
        ParameterAnnotationsAttributeEditor annotationsAttributeEditor = new ParameterAnnotationsAttributeEditor(attribute);
        boolean allEmpty = true;
        for (int parameterIndex = 0; parameterIndex < attribute.u1parametersCount; ++parameterIndex) {
            Annotation[] annotations = attribute.parameterAnnotations[parameterIndex];
            int index = 0;
            while (index < attribute.u2parameterAnnotationsCount[parameterIndex]) {
                Annotation annotation = annotations[index];
                if (annotation.getProcessingInfo() == this.mark) {
                    annotationsAttributeEditor.deleteAnnotation(parameterIndex, index);
                    continue;
                }
                ++index;
            }
            if (attribute.u2parameterAnnotationsCount[parameterIndex] == 0) continue;
            allEmpty = false;
        }
        if (allEmpty) {
            AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)member, false);
            attributesEditor.deleteAttribute(attributeName);
        }
    }
}

