/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.ClassUsageMarker;
import proguard.util.Processable;

public class LocalVariableTypeUsageMarker
implements AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
ClassVisitor,
ConstantVisitor {
    private final ClassUsageMarker classUsageMarker;
    private boolean tableUsed;
    private boolean variableInfoUsed;

    public LocalVariableTypeUsageMarker(ClassUsageMarker classUsageMarker) {
        this.classUsageMarker = classUsageMarker;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.tableUsed = false;
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableInfoVisitor)this);
        if (this.tableUsed) {
            this.classUsageMarker.markAsUsed((Processable)localVariableTableAttribute);
            this.markConstant(clazz, localVariableTableAttribute.u2attributeNameIndex);
        }
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.tableUsed = false;
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, (LocalVariableTypeInfoVisitor)this);
        if (this.tableUsed) {
            this.classUsageMarker.markAsUsed((Processable)localVariableTypeTableAttribute);
            this.markConstant(clazz, localVariableTypeTableAttribute.u2attributeNameIndex);
        }
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        this.variableInfoUsed = true;
        localVariableInfo.referencedClassAccept((ClassVisitor)this);
        if (this.variableInfoUsed) {
            this.classUsageMarker.markAsUsed((Processable)localVariableInfo);
            this.markConstant(clazz, localVariableInfo.u2nameIndex);
            this.markConstant(clazz, localVariableInfo.u2descriptorIndex);
            this.tableUsed = true;
        }
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.variableInfoUsed = true;
        localVariableTypeInfo.referencedClassesAccept((ClassVisitor)this);
        if (this.variableInfoUsed) {
            this.classUsageMarker.markAsUsed((Processable)localVariableTypeInfo);
            this.markConstant(clazz, localVariableTypeInfo.u2nameIndex);
            this.markConstant(clazz, localVariableTypeInfo.u2signatureIndex);
            this.tableUsed = true;
        }
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (!this.classUsageMarker.isUsed((Processable)programClass)) {
            this.variableInfoUsed = false;
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.classUsageMarker.markAsUsed((Processable)constant);
    }

    private void markConstant(Clazz clazz, int index) {
        clazz.constantPoolEntryAccept(index, (ConstantVisitor)this);
    }
}

