/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.util.WarningLogger;
import proguard.pass.Pass;
import proguard.util.kotlin.asserter.KotlinMetadataAsserter;

public class KotlinMetadataVerifier
implements Pass {
    private static final Logger logger = LogManager.getLogger(KotlinMetadataVerifier.class);
    private final Configuration configuration;

    public KotlinMetadataVerifier(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) {
        WarningLogger warningLogger = new WarningLogger(logger, this.configuration.warn);
        KotlinMetadataAsserter kotlinMetadataAsserter = new KotlinMetadataAsserter();
        kotlinMetadataAsserter.execute(warningLogger, appView.programClassPool, appView.libraryClassPool, appView.resourceFilePool);
        int warningCount = warningLogger.getWarningCount();
        if (warningCount > 0) {
            logger.warn("Warning: there were {} errors during Kotlin metadata verification.", (Object)warningCount);
        }
    }
}

