/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintHeapAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapPrincipalAbstractState;
import proguard.analysis.cpa.state.MapAbstractStateFactory;

public class JvmTaintTreeHeapFollowerAbstractState
extends JvmTreeHeapFollowerAbstractState<SetAbstractState<JvmTaintSource>>
implements JvmTaintHeapAbstractState {
    public JvmTaintTreeHeapFollowerAbstractState(JvmReferenceAbstractState principal, SetAbstractState<JvmTaintSource> defaultValue, MapAbstractState<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> referenceToNode, MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> heapMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> heapNodeMapAbstractStateFactory) {
        super(principal, defaultValue, referenceToNode, heapMapAbstractStateFactory, heapNodeMapAbstractStateFactory);
    }

    @Override
    public <T> void taintObject(T object, SetAbstractState<JvmTaintSource> value) {
        this.setField(object, "", value);
    }

    @Override
    public <T> SetAbstractState<JvmTaintSource> getFieldOrDefault(T object, String fqn, SetAbstractState<JvmTaintSource> defaultValue) {
        return super.getFieldOrDefault(object, fqn, defaultValue.join(super.getFieldOrDefault(object, "", SetAbstractState.bottom)));
    }

    @Override
    public <T> SetAbstractState<JvmTaintSource> getArrayElementOrDefault(T array, SetAbstractState<JvmTaintSource> index, SetAbstractState<JvmTaintSource> defaultValue) {
        return super.getArrayElementOrDefault(array, index, defaultValue.join(super.getFieldOrDefault(array, "", SetAbstractState.bottom)));
    }

    @Override
    protected void assignField(SetAbstractState<Reference> object, String descriptor, SetAbstractState<JvmTaintSource> value) {
        if (!descriptor.equals("")) {
            super.assignField(object, descriptor, value);
            return;
        }
        this.taintObjects(this.getReachableReferences(object, (JvmTreeHeapPrincipalAbstractState)this.principal.getHeap()), this.referenceToObject, value);
    }

    @Override
    public JvmTaintTreeHeapFollowerAbstractState join(JvmHeapAbstractState<SetAbstractState<JvmTaintSource>> abstractState) {
        JvmTaintTreeHeapFollowerAbstractState other = (JvmTaintTreeHeapFollowerAbstractState)abstractState;
        MapAbstractState<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> newReferenceToNode = this.referenceToObject.join(other.referenceToObject);
        if (this.referenceToObject == newReferenceToNode) {
            return this;
        }
        if (other.referenceToObject == newReferenceToNode) {
            return other;
        }
        this.propagateObjectTaint(this.referenceToObject, newReferenceToNode, other.principal.getHeap());
        this.propagateObjectTaint(other.referenceToObject, newReferenceToNode, this.principal.getHeap());
        return new JvmTaintTreeHeapFollowerAbstractState(this.principal, (SetAbstractState)this.defaultValue, newReferenceToNode, this.heapMapAbstractStateFactory, this.heapNodeMapAbstractStateFactory);
    }

    @Override
    public JvmTaintTreeHeapFollowerAbstractState copy() {
        return new JvmTaintTreeHeapFollowerAbstractState(this.principal, (SetAbstractState)this.defaultValue, this.referenceToObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HeapNode)e.getValue()).copy(), HeapNode::join, this.heapMapAbstractStateFactory::createMapAbstractState)), this.heapMapAbstractStateFactory, this.heapNodeMapAbstractStateFactory);
    }

    private SetAbstractState<Reference> getReachableReferences(Set<Reference> references, JvmTreeHeapPrincipalAbstractState principal) {
        SetAbstractState<Reference> result = new SetAbstractState<Reference>(new Reference[0]);
        ArrayDeque worklist = new ArrayDeque();
        references.forEach(worklist::push);
        while (!worklist.isEmpty()) {
            Reference reference = (Reference)worklist.pop();
            result.add(reference);
            Optional.ofNullable(principal.getHeapNode(reference)).ifPresent(n -> n.values().stream().flatMap(Collection::stream).filter(r -> !result.contains(r)).forEach(r -> {
                result.add(r);
                worklist.push(r);
            }));
        }
        return result;
    }

    private void taintObjects(SetAbstractState<Reference> references, Map<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> referenceToNode, SetAbstractState<JvmTaintSource> value) {
        references.stream().map(referenceToNode::get).filter(Objects::nonNull).forEach(n -> n.replaceAll((k, v) -> v.join(value)));
        references.stream().map(xva$0 -> new SetAbstractState<Reference>(xva$0)).forEach(r -> this.mergeField((SetAbstractState<Reference>)r, "", value));
    }

    private void propagateObjectTaint(MapAbstractState<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> leftReferenceToNode, MapAbstractState<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> joinedReferenceToNode, JvmHeapAbstractState<SetAbstractState<Reference>> rightPrincipalHeap) {
        leftReferenceToNode.entrySet().stream().filter(e -> ((HeapNode)e.getValue()).containsKey("")).collect(Collectors.groupingBy(e -> (SetAbstractState)((HeapNode)e.getValue()).get(""))).forEach((taint, group) -> this.taintObjects(this.getReachableReferences(group.stream().flatMap(heapEntry -> ((HeapNode)joinedReferenceToNode.get(heapEntry.getKey())).entrySet().stream().filter(o -> !((HeapNode)heapEntry.getValue()).containsKey(o.getKey())).map(o -> {
            o.setValue(((SetAbstractState)o.getValue()).join(taint));
            return rightPrincipalHeap.getFieldOrDefault(new SetAbstractState<Reference>((Reference)heapEntry.getKey()), (String)o.getKey(), SetAbstractState.bottom);
        })).flatMap(Collection::stream).collect(Collectors.toSet()), (JvmTreeHeapPrincipalAbstractState)rightPrincipalHeap), (Map<Reference, HeapNode<SetAbstractState<JvmTaintSource>>>)joinedReferenceToNode, (SetAbstractState<JvmTaintSource>)taint));
    }
}

