/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapPrincipalAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.state.MapAbstractStateFactory;

public class JvmTreeHeapFollowerAbstractState<StateT extends LatticeAbstractState<StateT>>
extends JvmTreeHeapAbstractState<StateT> {
    protected JvmReferenceAbstractState principal;

    public JvmTreeHeapFollowerAbstractState(JvmReferenceAbstractState principal, StateT defaultValue, MapAbstractState<Reference, HeapNode<StateT>> referenceToNode, MapAbstractStateFactory<Reference, HeapNode<StateT>> heapMapAbstractStateFactory, MapAbstractStateFactory<String, StateT> heapNodeMapAbstractStateFactory) {
        super(referenceToNode, heapMapAbstractStateFactory, heapNodeMapAbstractStateFactory, defaultValue);
        this.principal = principal;
    }

    @Override
    public <T> StateT getFieldOrDefault(T object, String fqn, StateT defaultValue) {
        if (object instanceof JvmMemoryLocation) {
            return this.getField(this.getReferenceAbstractState((JvmMemoryLocation)object), fqn, defaultValue);
        }
        if (object instanceof SetAbstractState) {
            return this.getField((SetAbstractState)object, fqn, defaultValue);
        }
        throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), object.getClass().getName()));
    }

    @Override
    public <T> void setField(T object, String fqn, StateT value) {
        if (object instanceof JvmMemoryLocation) {
            this.assignField(this.getReferenceAbstractState((JvmMemoryLocation)object), fqn, value);
            return;
        }
        if (object instanceof SetAbstractState) {
            this.assignField((SetAbstractState)object, fqn, value);
            return;
        }
        throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), object.getClass().getName()));
    }

    @Override
    public <T> StateT getArrayElementOrDefault(T array, StateT index, StateT defaultValue) {
        if (array instanceof JvmMemoryLocation) {
            return this.getArrayElementOrDefault((T)this.getReferenceAbstractState((JvmMemoryLocation)array), index, defaultValue);
        }
        if (array instanceof SetAbstractState) {
            return this.getArrayElementOrDefault((T)((SetAbstractState)array), index, defaultValue);
        }
        throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), array.getClass().getName()));
    }

    @Override
    public <T> void setArrayElement(T array, StateT index, StateT value) {
        if (array instanceof JvmMemoryLocation) {
            this.setArrayElement((T)this.getReferenceAbstractState((JvmMemoryLocation)array), index, value);
            return;
        }
        if (array instanceof SetAbstractState) {
            this.setArrayElement((T)((SetAbstractState)array), index, value);
            return;
        }
        throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), array.getClass().getName()));
    }

    @Override
    public StateT newObject(String className, JvmCfaNode creationCite) {
        return (StateT)this.defaultValue;
    }

    @Override
    public StateT newArray(String type, List<StateT> dimensions, JvmCfaNode creationCite) {
        return (StateT)this.defaultValue;
    }

    @Override
    public void reduce(Set<Object> references) {
        Set toKeep = ((JvmTreeHeapPrincipalAbstractState)this.principal.getHeap()).referenceToObject.keySet();
        if (toKeep.size() >= this.referenceToObject.size()) {
            return;
        }
        this.referenceToObject.keySet().retainAll(toKeep);
    }

    @Override
    public JvmTreeHeapFollowerAbstractState<StateT> join(JvmHeapAbstractState<StateT> abstractState) {
        JvmTreeHeapFollowerAbstractState other = (JvmTreeHeapFollowerAbstractState)abstractState;
        MapAbstractState<Reference, HeapNode<StateT>> newReferenceToNode = this.referenceToObject.join(other.referenceToObject);
        if (this.referenceToObject == newReferenceToNode) {
            return this;
        }
        if (other.referenceToObject == newReferenceToNode) {
            return other;
        }
        return new JvmTreeHeapFollowerAbstractState<LatticeAbstractState>(this.principal, this.defaultValue, newReferenceToNode, this.heapMapAbstractStateFactory, this.heapNodeMapAbstractStateFactory);
    }

    @Override
    public JvmTreeHeapFollowerAbstractState<StateT> copy() {
        return new JvmTreeHeapFollowerAbstractState<LatticeAbstractState>(this.principal, this.defaultValue, this.referenceToObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HeapNode)e.getValue()).copy(), HeapNode::join, this.heapMapAbstractStateFactory::createMapAbstractState)), this.heapMapAbstractStateFactory, this.heapNodeMapAbstractStateFactory);
    }

    public void setPrincipalState(JvmReferenceAbstractState principal) {
        this.principal = principal;
    }

    public SetAbstractState<Reference> getReferenceAbstractState(JvmMemoryLocation principalMemoryLocation) {
        return principalMemoryLocation.extractValueOrDefault(this.principal, SetAbstractState.bottom);
    }
}

