/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassConstantClassFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.FixedStringMatcher;
import proguard.util.StringMatcher;

public class DynamicClassReferenceInitializer
implements ClassVisitor,
InstructionVisitor,
ConstantVisitor,
AttributeVisitor {
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    private final Constant[] CLASS_FOR_NAME_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("forName"), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/Class;"), new MethodrefConstant(1, 7, null, null), new NameAndTypeConstant(8, 9), new Utf8Constant("newInstance"), new Utf8Constant("()Ljava/lang/Object;"), new MethodrefConstant(1, 11, null, null), new NameAndTypeConstant(12, 13), new Utf8Constant("getComponentType"), new Utf8Constant("()Ljava/lang/Class;"), new MethodrefConstant(1, 15, null, null), new NameAndTypeConstant(16, 17), new Utf8Constant("getClassLoader"), new Utf8Constant("()Ljava/lang/ClassLoader;"), new MethodrefConstant(1, 19, null, null), new NameAndTypeConstant(4, 20), new Utf8Constant("(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;")};
    private final Instruction[] CONSTANT_CLASS_FOR_NAME_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(-72, 0)};
    private final Instruction[] CONSTANT_CLASS_FOR_NAME_3_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new SimpleInstruction(3, 0x40000001), new ConstantInstruction(18, 0x40000002), new ConstantInstruction(-74, 14), new ConstantInstruction(-72, 18)};
    private final Instruction[] CLASS_FOR_NAME_CAST_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(-72, 0), new ConstantInstruction(-74, 6), new ConstantInstruction(-64, 0x40000000)};
    private final Constant[] DOT_CLASS_JAVAC_CONSTANTS = new Constant[]{new MethodrefConstant(0x40000003, 1, null, null), new NameAndTypeConstant(0x40000004, 2), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/Class;")};
    private final Instruction[] DOT_CLASS_JAVAC_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(-72, 0)};
    private final Constant[] DOT_CLASS_JIKES_CONSTANTS = new Constant[]{new MethodrefConstant(0x40000003, 1, null, null), new NameAndTypeConstant(0x40000004, 2), new Utf8Constant("(Ljava/lang/String;Z)Ljava/lang/Class;")};
    private final Instruction[] DOT_CLASS_JIKES_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new SimpleInstruction(3), new ConstantInstruction(-72, 0)};
    private final Instruction[] DOT_CLASS_JAVAC_IMPLEMENTATION_INSTRUCTIONS = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-72, 0), new SimpleInstruction(-80)};
    private final Instruction[] DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-72, 0), new VariableInstruction(43), new BranchInstruction(-102, 6), new ConstantInstruction(-74, 10), new SimpleInstruction(-80)};
    private final Instruction[] DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS2 = new Instruction[]{new VariableInstruction(42), new ConstantInstruction(-72, 0), new ConstantInstruction(-74, 10), new SimpleInstruction(-80)};
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter missingNotePrinter;
    private final WarningPrinter dependencyWarningPrinter;
    private final WarningPrinter notePrinter;
    private final StringMatcher noteExceptionMatcher;
    private final ClassVisitor extraClassVisitor;
    private final InstructionSequenceMatcher constantClassForNameMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.CONSTANT_CLASS_FOR_NAME_INSTRUCTIONS);
    private final InstructionSequenceMatcher constantClassForName3Matcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.CONSTANT_CLASS_FOR_NAME_3_INSTRUCTIONS);
    private final InstructionSequenceMatcher classForNameCastMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.CLASS_FOR_NAME_CAST_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJavacMatcher = new InstructionSequenceMatcher(this.DOT_CLASS_JAVAC_CONSTANTS, this.DOT_CLASS_JAVAC_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJikesMatcher = new InstructionSequenceMatcher(this.DOT_CLASS_JIKES_CONSTANTS, this.DOT_CLASS_JIKES_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJavacImplementationMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.DOT_CLASS_JAVAC_IMPLEMENTATION_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJikesImplementationMatcher = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS);
    private final InstructionSequenceMatcher dotClassJikesImplementationMatcher2 = new InstructionSequenceMatcher(this.CLASS_FOR_NAME_CONSTANTS, this.DOT_CLASS_JIKES_IMPLEMENTATION_INSTRUCTIONS2);
    private final ClassConstantClassFilter classConstantClassFilter = new ClassConstantClassFilter(new FixedStringMatcher("java/lang/Class"), (ClassVisitor)new AllMethodVisitor(new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)new AllInstructionVisitor(this)))));
    private boolean isClassForNameInvocation;

    public DynamicClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter missingNotePrinter, WarningPrinter dependencyWarningPrinter, WarningPrinter notePrinter, StringMatcher noteExceptionMatcher) {
        this(programClassPool, libraryClassPool, missingNotePrinter, dependencyWarningPrinter, notePrinter, noteExceptionMatcher, null);
    }

    public DynamicClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter missingNotePrinter, WarningPrinter dependencyWarningPrinter, WarningPrinter notePrinter, StringMatcher noteExceptionMatcher, ClassVisitor extraClassVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.missingNotePrinter = missingNotePrinter;
        this.dependencyWarningPrinter = dependencyWarningPrinter;
        this.notePrinter = notePrinter;
        this.noteExceptionMatcher = noteExceptionMatcher;
        this.extraClassVisitor = extraClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.accept(this.classConstantClassFilter);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        instruction.accept(clazz, method, codeAttribute, offset, this.classForNameCastMatcher);
        if (this.classForNameCastMatcher.isMatching()) {
            clazz.constantPoolEntryAccept(this.classForNameCastMatcher.matchedConstantIndex(0x40000000), this);
        }
        instruction.accept(clazz, method, codeAttribute, offset, new MultiInstructionVisitor(this.constantClassForNameMatcher, this.constantClassForName3Matcher));
        if (this.constantClassForNameMatcher.isMatching() || this.constantClassForName3Matcher.isMatching()) {
            InstructionSequenceMatcher matchedMatcher = this.constantClassForNameMatcher.isMatching() ? this.constantClassForNameMatcher : this.constantClassForName3Matcher;
            clazz.constantPoolEntryAccept(matchedMatcher.matchedConstantIndex(0x40000000), this);
            this.classForNameCastMatcher.reset();
            return;
        }
        instruction.accept(clazz, method, codeAttribute, offset, this.dotClassJavacMatcher);
        if (this.dotClassJavacMatcher.isMatching() && this.isDotClassMethodref(clazz, this.dotClassJavacMatcher.matchedConstantIndex(0))) {
            clazz.constantPoolEntryAccept(this.dotClassJavacMatcher.matchedConstantIndex(0x40000000), this);
            return;
        }
        instruction.accept(clazz, method, codeAttribute, offset, this.dotClassJikesMatcher);
        if (this.dotClassJikesMatcher.isMatching() && this.isDotClassMethodref(clazz, this.dotClassJikesMatcher.matchedConstantIndex(0))) {
            clazz.constantPoolEntryAccept(this.dotClassJikesMatcher.matchedConstantIndex(0x40000000), this);
        }
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String externalClassName = stringConstant.getString(clazz);
        String internalClassName = ClassUtil.internalClassName(ClassUtil.externalBaseType(externalClassName));
        stringConstant.referencedClass = this.findClass(clazz.getName(), internalClassName);
        if (stringConstant.referencedClass != null && this.extraClassVisitor != null) {
            stringConstant.referencedClass.accept(this.extraClassVisitor);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (!(this.notePrinter == null || this.noteExceptionMatcher != null && this.noteExceptionMatcher.matches(classConstant.getName(clazz)))) {
            this.notePrinter.print(clazz.getName(), classConstant.getName(clazz), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " calls '(" + ClassUtil.externalClassName(classConstant.getName(clazz)) + ")Class.forName(variable).newInstance()'");
        }
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        String methodType = methodrefConstant.getType(clazz);
        if (methodType.equals("(Ljava/lang/String;)Ljava/lang/Class;") || methodType.equals("(Ljava/lang/String;Z)Ljava/lang/Class;")) {
            String methodName = methodrefConstant.getName(clazz);
            boolean bl = this.isClassForNameInvocation = methodName.equals("class$") || methodName.equals("class");
            if (this.isClassForNameInvocation) {
                return;
            }
            String className = methodrefConstant.getClassName(clazz);
            Clazz referencedClass = this.programClassPool.getClass(className);
            if (referencedClass != null) {
                referencedClass.methodAccept(methodName, methodType, new AllAttributeVisitor(this));
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.isClassForNameInvocation = this.isDotClassMethodCode(clazz, method, codeAttribute, this.dotClassJavacImplementationMatcher, 5) || this.isDotClassMethodCode(clazz, method, codeAttribute, this.dotClassJikesImplementationMatcher, 12) || this.isDotClassMethodCode(clazz, method, codeAttribute, this.dotClassJikesImplementationMatcher2, 8);
    }

    private boolean isDotClassMethodref(Clazz clazz, int methodrefConstantIndex) {
        this.isClassForNameInvocation = false;
        clazz.constantPoolEntryAccept(methodrefConstantIndex, this);
        return this.isClassForNameInvocation;
    }

    private boolean isDotClassMethodCode(Clazz clazz, Method method, CodeAttribute codeAttribute, InstructionSequenceMatcher codeMatcher, int codeLength) {
        if (codeAttribute.u4codeLength < codeLength) {
            return false;
        }
        codeMatcher.reset();
        codeAttribute.instructionsAccept(clazz, method, 0, codeLength, codeMatcher);
        return codeMatcher.isMatching();
    }

    private Clazz findClass(String referencingClassName, String name) {
        Clazz clazz;
        if (ClassUtil.isInternalArrayType(name)) {
            if (!ClassUtil.isInternalClassType(name)) {
                return null;
            }
            name = ClassUtil.internalClassNameFromClassType(name);
        }
        if ((clazz = this.programClassPool.getClass(name)) == null) {
            clazz = this.libraryClassPool.getClass(name);
            if (clazz == null && this.missingNotePrinter != null) {
                this.missingNotePrinter.print(referencingClassName, name, "Note: " + ClassUtil.externalClassName(referencingClassName) + ": can't find dynamically referenced class " + ClassUtil.externalClassName(name));
            }
        } else if (this.dependencyWarningPrinter != null) {
            this.dependencyWarningPrinter.print(referencingClassName, name, "Warning: library class " + ClassUtil.externalClassName(referencingClassName) + " depends dynamically on program class " + ClassUtil.externalClassName(name));
        }
        return clazz;
    }
}

