/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.kotlin;

import proguard.classfile.util.kotlin.KotlinStringUtil;

public class KotlinNameUtil {
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";

    private KotlinNameUtil() {
    }

    public static String generateGetterName(String name) {
        return KotlinNameUtil.startsWithIsPrefix(name) ? name : KotlinNameUtil.prefixName(GET_PREFIX, name);
    }

    public static String generateSetterName(String name) {
        return KotlinNameUtil.prefixName(SET_PREFIX, KotlinNameUtil.startsWithIsPrefix(name) ? name.substring(IS_PREFIX.length()) : name);
    }

    public static boolean isGetterName(String name) {
        return name.startsWith(GET_PREFIX) || name.startsWith(IS_PREFIX);
    }

    public static boolean isSetterName(String name) {
        return name.startsWith(SET_PREFIX);
    }

    private static boolean startsWithIsPrefix(String name) {
        if (!name.startsWith(IS_PREFIX) || name.equals(IS_PREFIX)) {
            return false;
        }
        char firstCharAfterIsPrefix = name.charAt(IS_PREFIX.length());
        return 'a' > firstCharAfterIsPrefix || firstCharAfterIsPrefix > 'z';
    }

    private static String prefixName(String prefix, String name) {
        if (name.length() == 0) {
            return name;
        }
        return prefix + KotlinStringUtil.capitializeFirstCharacterAsciiOnly(name);
    }

    public static String getterNameToPropertyName(String name, boolean stripAfterDollar) {
        if (stripAfterDollar && name.contains("$")) {
            name = name.substring(0, name.indexOf("$"));
        }
        if (KotlinNameUtil.isGetterName(name)) {
            if (name.startsWith(GET_PREFIX)) {
                return KotlinStringUtil.decapitializeForKotlinCompiler(name.substring(GET_PREFIX.length()));
            }
            return name;
        }
        if (KotlinNameUtil.isSetterName(name)) {
            return KotlinStringUtil.decapitializeForKotlinCompiler(name.substring(SET_PREFIX.length()));
        }
        return name;
    }
}

