/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.util.jsonprinter;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.evaluation.util.jsonprinter.JsonPrinter;
import proguard.evaluation.util.jsonprinter.JsonSerializable;

class BranchTargetRecord
implements JsonSerializable {
    @NotNull
    private final List<String> startVariables;
    @NotNull
    private final List<String> startStack;
    private final int startOffset;

    public BranchTargetRecord(@NotNull List<String> variables, @NotNull List<String> stack, int startOffset) {
        this.startVariables = variables;
        this.startStack = stack;
        this.startOffset = startOffset;
    }

    @Override
    public StringBuilder toJson(StringBuilder builder) {
        builder.append("{");
        JsonPrinter.toJson("startOffset", this.startOffset, builder).append(",");
        JsonPrinter.stringListToJson("startStack", this.startStack, builder).append(",");
        return JsonPrinter.stringListToJson("startVariables", this.startVariables, builder).append("}");
    }

    @NotNull
    public List<String> getStartVariables() {
        return this.startVariables;
    }

    @NotNull
    public List<String> getStartStack() {
        return this.startStack;
    }

    public int getStartOffset() {
        return this.startOffset;
    }
}

