/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.metadata.jvm.KmModule;
import kotlin.metadata.jvm.KmPackageParts;
import kotlin.metadata.jvm.KotlinModuleMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.KotlinModulePackage;

public class KotlinModuleReader
implements ResourceFileVisitor {
    private final BiConsumer<KotlinModule, String> errorHandler;
    private final InputStream inputStream;

    public KotlinModuleReader(InputStream inputStream) {
        this(null, inputStream);
    }

    public KotlinModuleReader(BiConsumer<KotlinModule, String> errorHandler, InputStream inputStream) {
        this.errorHandler = errorHandler;
        this.inputStream = inputStream;
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        try {
            int count;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = this.inputStream.read(buffer)) >= 0) {
                byteStream.write(buffer, 0, count);
            }
            byte[] bytes = byteStream.toByteArray();
            KotlinModuleMetadata kotlinModuleMetadata = KotlinModuleMetadata.read((byte[])bytes);
            KmModule kmModule = Objects.requireNonNull(kotlinModuleMetadata).getKmModule();
            kotlinModule.version = this.getKotlinModuleMetadataVersion(bytes);
            kotlinModule.modulePackages.addAll(kmModule.getPackageParts().entrySet().stream().map(entry -> new KotlinModulePackage(((String)entry.getKey()).replace('.', '/'), ((KmPackageParts)entry.getValue()).getFileFacades(), ((KmPackageParts)entry.getValue()).getMultiFileClassParts())).collect(Collectors.toList()));
        }
        catch (IOException | NullPointerException e) {
            if (this.errorHandler != null) {
                this.errorHandler.accept(kotlinModule, e.getMessage());
            }
            throw new RuntimeException("Error while reading Kotlin module file", e);
        }
    }

    private KotlinMetadataVersion getKotlinModuleMetadataVersion(byte[] module) {
        try {
            DataInputStream bytes = new DataInputStream(new ByteArrayInputStream(module));
            int size = bytes.readInt();
            if (size < 0 || size > 1024) {
                return KotlinMetadataVersion.UNKNOWN_VERSION;
            }
            int[] version = new int[size];
            for (int i = 0; i < size; ++i) {
                version[i] = bytes.readInt();
            }
            return new KotlinMetadataVersion(version);
        }
        catch (IOException e) {
            return KotlinMetadataVersion.UNKNOWN_VERSION;
        }
    }
}

