/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

public class CircularIntBuffer {
    private final int[] buffer;
    private int head;
    private int curSize;

    public CircularIntBuffer(int maxSize) {
        this.buffer = new int[maxSize];
        this.head = 0;
    }

    public void push(int value) {
        this.head = (this.head + 1) % this.buffer.length;
        this.buffer[this.head] = value;
        if (this.curSize < this.buffer.length) {
            ++this.curSize;
        }
    }

    public int peek(int offset) {
        if (offset >= this.curSize) {
            throw new IndexOutOfBoundsException("Offset [" + offset + "] out of bounds for buffer of size " + this.curSize + ".");
        }
        return this.buffer[Math.floorMod(this.head - offset, this.buffer.length)];
    }

    public int peek() {
        return this.peek(0);
    }

    public int size() {
        return this.curSize;
    }
}

