/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.util.Processable;

public interface ProcessableVisitor
extends ClassVisitor,
MemberVisitor,
AttributeVisitor,
ResourceFileVisitor,
ConstantVisitor {
    default public void visitAnyProcessable(Processable processable) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + processable.getClass().getName());
    }

    @Override
    default public void visitAnyClass(Clazz clazz) {
        this.visitAnyProcessable(clazz);
    }

    @Override
    default public void visitAnyMember(Clazz clazz, Member member) {
        this.visitAnyProcessable(member);
    }

    @Override
    default public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.visitAnyProcessable(attribute);
    }

    @Override
    default public void visitAnyResourceFile(ResourceFile resourceFile) {
        this.visitAnyProcessable(resourceFile);
    }

    @Override
    default public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.visitAnyProcessable(constant);
    }
}

