/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.junit.testparameterinjector;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;

final class ByteStringReflection {
    static final Optional<Class<?>> MAYBE_BYTE_STRING_CLASS = ByteStringReflection.maybeGetByteStringClass();

    static boolean isInstanceOfByteString(Object object) {
        if (MAYBE_BYTE_STRING_CLASS.isPresent()) {
            return ((Class)MAYBE_BYTE_STRING_CLASS.get()).isInstance(object);
        }
        return false;
    }

    static byte[] byteStringToByteArray(Object byteString) {
        return (byte[])ByteStringReflection.invokeByteStringMethod("toByteArray", byteString, ImmutableMap.of());
    }

    static Object copyFromUtf8(String text) {
        return ByteStringReflection.invokeByteStringMethod("copyFromUtf8", null, ImmutableMap.of(String.class, (Object)text));
    }

    static Object copyFrom(byte[] bytes) {
        return ByteStringReflection.invokeByteStringMethod("copyFrom", null, ImmutableMap.of(byte[].class, (Object)bytes));
    }

    private static Object invokeByteStringMethod(String methodName, Object obj, ImmutableMap<Class<?>, ?> args) {
        try {
            return ((Class)MAYBE_BYTE_STRING_CLASS.get()).getMethod(methodName, (Class[])args.keySet().toArray((Object[])new Class[0])).invoke(obj, args.values().toArray());
        }
        catch (IllegalAccessException e) {
            throw new LinkageError(String.format("Accessing %s()", methodName), e);
        }
        catch (InvocationTargetException e) {
            throw new LinkageError(String.format("Calling %s()", methodName), e);
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError(String.format("Calling %s()", methodName), e);
        }
    }

    private static Optional<Class<?>> maybeGetByteStringClass() {
        try {
            return Optional.of(Class.forName("com.google.protobuf.ByteString"));
        }
        catch (ClassNotFoundException | LinkageError unused) {
            return Optional.absent();
        }
    }

    private ByteStringReflection() {
    }
}

