/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.handler;

import com.google.caliper.bridge.TargetInfoLogMessage;
import com.google.caliper.bridge.TargetInfoRequest;
import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.Running;
import com.google.caliper.worker.connection.ClientConnectionService;
import com.google.caliper.worker.handler.HostDevice;
import com.google.caliper.worker.handler.RequestHandler;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;

final class TargetInfoHandler
implements RequestHandler {
    private final ClientConnectionService clientConnection;
    private final Class<?> benchmarkClass;

    @Inject
    TargetInfoHandler(ClientConnectionService clientConnection, @Running.BenchmarkClass Class<?> benchmarkClass) {
        this.clientConnection = clientConnection;
        this.benchmarkClass = benchmarkClass;
    }

    @Override
    public void handleRequest(WorkerRequest request) throws IOException {
        TargetInfoRequest targetInfoRequest = (TargetInfoRequest)request;
        BenchmarkClassModel model = BenchmarkClassModel.create(this.benchmarkClass);
        BenchmarkClassModel.validateUserParameters(this.benchmarkClass, (SetMultimap)targetInfoRequest.userParameters());
        this.clientConnection.send(new Serializable[]{TargetInfoLogMessage.create((BenchmarkClassModel)model, HostDevice.getProperties())});
    }
}

