/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.config;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.runner.config.DeviceConfig;
import com.google.caliper.runner.config.DeviceType;
import com.google.caliper.runner.config.InstrumentConfig;
import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.config.ResultProcessorConfig;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.util.Util;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CaliperConfig {
    @VisibleForTesting
    final ImmutableMap<String, String> properties;
    private final ImmutableMap<Class<? extends ResultProcessor>, ResultProcessorConfig> resultProcessorConfigs;
    private static final Pattern CLASS_PROPERTY_PATTERN = Pattern.compile("(\\w+)\\.class");
    private static final Pattern INSTRUMENT_CLASS_PATTERN = Pattern.compile("([^\\.]+)\\.class");

    @VisibleForTesting
    public CaliperConfig(ImmutableMap<String, String> properties) throws InvalidConfigurationException {
        this.properties = (ImmutableMap)Preconditions.checkNotNull(properties);
        this.resultProcessorConfigs = CaliperConfig.findResultProcessorConfigs((ImmutableMap<String, String>)Util.subgroupMap(properties, (String)"results"));
    }

    private static <T> ImmutableBiMap<String, Class<? extends T>> mapGroupNamesToClasses(ImmutableMap<String, String> groupProperties, Class<T> type) throws InvalidConfigurationException {
        HashBiMap namesToClasses = HashBiMap.create();
        for (Map.Entry entry : groupProperties.entrySet()) {
            Matcher matcher = CLASS_PROPERTY_PATTERN.matcher((CharSequence)entry.getKey());
            if (!matcher.matches() || ((String)entry.getValue()).isEmpty()) continue;
            try {
                Class someClass = Util.loadClass((String)((String)entry.getValue()));
                Preconditions.checkState((boolean)type.isAssignableFrom(someClass));
                Class verifiedClass = someClass;
                namesToClasses.put((Object)matcher.group(1), (Object)verifiedClass);
            }
            catch (ClassNotFoundException e) {
                String string = String.valueOf((String)entry.getValue());
                throw new InvalidConfigurationException(string.length() != 0 ? "Cannot find result processor class: ".concat(string) : new String("Cannot find result processor class: "));
            }
        }
        return ImmutableBiMap.copyOf((Map)namesToClasses);
    }

    private static ImmutableMap<Class<? extends ResultProcessor>, ResultProcessorConfig> findResultProcessorConfigs(ImmutableMap<String, String> resultsProperties) throws InvalidConfigurationException {
        ImmutableBiMap<String, Class<ResultProcessor>> processorToClass = CaliperConfig.mapGroupNamesToClasses(resultsProperties, ResultProcessor.class);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : processorToClass.entrySet()) {
            builder.put((Object)((Class)entry.getValue()), (Object)CaliperConfig.getResultProcessorConfig(resultsProperties, (String)entry.getKey()));
        }
        return builder.build();
    }

    public ImmutableMap<String, String> properties() {
        return this.properties;
    }

    public DeviceConfig getDeviceConfig(CaliperOptions options) {
        String deviceName = options.deviceName();
        ImmutableMap devices = Util.subgroupMap(this.properties, (String)"device");
        if (deviceName.equals("default")) {
            if (!Util.subgroupMap((Map)devices, (String)deviceName).isEmpty()) {
                throw new InvalidConfigurationException("device name 'default' is reserved; please use a different device name");
            }
            boolean hasAndroidClasspath = options.workerClasspath("android").isPresent();
            boolean hasJvmClasspath = options.workerClasspath("jvm").isPresent();
            if (hasAndroidClasspath && !hasJvmClasspath) {
                return this.getDeviceConfig("android");
            }
            return this.getDeviceConfig("local");
        }
        return this.getDeviceConfig(deviceName);
    }

    public DeviceConfig getDeviceConfig(String deviceName) {
        ImmutableMap devices = Util.subgroupMap(this.properties, (String)"device");
        ImmutableMap device = Util.subgroupMap((Map)devices, (String)deviceName);
        String deviceTypeField = (String)device.get((Object)"type");
        if (deviceTypeField == null) {
            throw new InvalidConfigurationException(new StringBuilder(41 + String.valueOf(deviceName).length()).append("Missing configuration field: device.").append(deviceName).append(".type").toString());
        }
        return DeviceConfig.builder().name(deviceName).type(DeviceType.of(deviceTypeField)).options((Map<String, String>)Util.subgroupMap((Map)device, (String)"options")).build();
    }

    public List<String> getVmArgs() {
        return CaliperConfig.getArgs((Map<String, String>)Util.subgroupMap(this.properties, (String)"vm"));
    }

    public VmConfig getVmConfig(String name) {
        String executable;
        String home;
        Preconditions.checkNotNull((Object)name);
        ImmutableMap vmGroupMap = Util.subgroupMap(this.properties, (String)"vm");
        ImmutableMap vmMap = Util.subgroupMap((Map)vmGroupMap, (String)name);
        VmConfig.Builder builder = VmConfig.builder().name(name);
        String type = (String)vmMap.get((Object)"type");
        if (type != null) {
            builder.type(VmType.of(type));
        }
        if ((home = (String)vmMap.get((Object)"home")) != null) {
            builder.home(home);
        }
        if ((executable = (String)vmMap.get((Object)"executable")) != null) {
            builder.executable(executable);
        }
        return builder.addAllArgs(this.getVmArgs()).addAllArgs(CaliperConfig.getArgs((Map<String, String>)vmMap)).build();
    }

    public ImmutableSet<String> getDefaultInstruments() {
        String instruments;
        ImmutableMap defaults = Util.subgroupMap(this.properties, (String)"defaults");
        if (!defaults.isEmpty() && (instruments = (String)defaults.get((Object)"instrument")) != null) {
            return ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)instruments));
        }
        throw new InvalidConfigurationException("Could not find default set of instruments to use (defaults.instrument in config file)");
    }

    public ImmutableSet<String> getConfiguredInstruments() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (String key : Util.subgroupMap(this.properties, (String)"instrument").keySet()) {
            Matcher matcher = INSTRUMENT_CLASS_PATTERN.matcher(key);
            if (!matcher.matches()) continue;
            resultBuilder.add((Object)matcher.group(1));
        }
        return resultBuilder.build();
    }

    public InstrumentConfig getInstrumentConfig(String name) {
        Preconditions.checkNotNull((Object)name);
        ImmutableMap instrumentGroupMap = Util.subgroupMap(this.properties, (String)"instrument");
        ImmutableMap instrumentMap = Util.subgroupMap((Map)instrumentGroupMap, (String)name);
        String className = (String)instrumentMap.get((Object)"class");
        Preconditions.checkArgument((className != null ? 1 : 0) != 0, (String)"no instrument configured named %s", (Object)name);
        return new InstrumentConfig.Builder().className(className).addAllOptions((Map<String, String>)Util.subgroupMap((Map)instrumentMap, (String)"options")).build();
    }

    public ImmutableSet<Class<? extends ResultProcessor>> getConfiguredResultProcessors() {
        return this.resultProcessorConfigs.keySet();
    }

    public ResultProcessorConfig getResultProcessorConfig(Class<? extends ResultProcessor> resultProcessorClass) {
        return (ResultProcessorConfig)this.resultProcessorConfigs.get(resultProcessorClass);
    }

    private static ResultProcessorConfig getResultProcessorConfig(ImmutableMap<String, String> resultsProperties, String name) {
        ImmutableMap resultsMap = Util.subgroupMap(resultsProperties, (String)name);
        return new ResultProcessorConfig.Builder().className((String)resultsMap.get((Object)"class")).addAllOptions((Map<String, String>)Util.subgroupMap((Map)resultsMap, (String)"options")).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("properties", this.properties).toString();
    }

    private static List<String> getArgs(Map<String, String> properties) {
        String argsString = Strings.nullToEmpty((String)properties.get("args"));
        ImmutableList.Builder args = ImmutableList.builder();
        StringBuilder arg = new StringBuilder();
        block4: for (int i = 0; i < argsString.length(); ++i) {
            char c = argsString.charAt(i);
            switch (c) {
                case '\\': {
                    arg.append(argsString.charAt(++i));
                    continue block4;
                }
                case ' ': {
                    if (arg.length() > 0) {
                        args.add((Object)arg.toString());
                    }
                    arg = new StringBuilder();
                    continue block4;
                }
                default: {
                    arg.append(c);
                }
            }
        }
        if (arg.length() > 0) {
            args.add((Object)arg.toString());
        }
        return args.build();
    }
}

