/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.experiment;

import com.google.auto.value.AutoValue;
import com.google.caliper.bridge.ExperimentSpec;
import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.runner.experiment.AutoValue_Experiment;
import com.google.caliper.runner.experiment.TrialSchedulingPolicy;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.target.Target;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.Map;

@AutoValue
public abstract class Experiment {
    public static Experiment create(int id, Instrument.InstrumentedMethod instrumentedMethod, Map<String, String> userParameters, Target target) {
        BenchmarkSpec benchmarkSpec = Experiment.createBenchmarkSpec(instrumentedMethod, userParameters);
        return new AutoValue_Experiment(id, instrumentedMethod, (ImmutableSortedMap<String, String>)ImmutableSortedMap.copyOf(userParameters), target, benchmarkSpec);
    }

    public abstract int id();

    public abstract Instrument.InstrumentedMethod instrumentedMethod();

    public abstract ImmutableSortedMap<String, String> userParameters();

    public abstract Target target();

    public abstract BenchmarkSpec benchmarkSpec();

    public final TrialSchedulingPolicy getTrialSchedulingPolicy() {
        return this.instrumentedMethod().instrument().parallelizable() ? TrialSchedulingPolicy.PARALLEL : TrialSchedulingPolicy.SERIAL;
    }

    public final ExperimentSpec toExperimentSpec() {
        return new ExperimentSpec(this.id(), this.instrumentedMethod().type(), this.instrumentedMethod().workerOptions(), this.benchmarkSpec(), (Iterable)ImmutableList.copyOf((Collection)this.instrumentedMethod().benchmarkMethod().parameterTypes()));
    }

    private static BenchmarkSpec createBenchmarkSpec(Instrument.InstrumentedMethod method, Map<String, String> userParameters) {
        return new BenchmarkSpec.Builder().className(method.benchmarkMethod().declaringClass()).methodName(method.benchmarkMethod().name()).addAllParameters(userParameters).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("instrument", (Object)this.instrumentedMethod().instrument()).add("benchmarkMethod", (Object)this.instrumentedMethod().benchmarkMethod().name()).add("target", (Object)this.target().name()).add("parameters", this.userParameters()).toString();
    }
}

