/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.resultprocessor;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.model.Trial;
import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.config.ResultProcessorConfig;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.gson.Gson;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ResultsUploader
implements ResultProcessor {
    static final Logger logger = Logger.getLogger(ResultsUploader.class.getName());
    private static final String POST_PATH = "/data/trials";
    private static final String RESULTS_PATH_PATTERN = "/runs/%s";
    private final PrintWriter stdout;
    private final UploadHandler handler;
    private final Gson gson;
    private final Optional<UUID> apiKey;
    private final Optional<URI> uploadUri;
    private Optional<UUID> runId = Optional.absent();
    private boolean failure = false;

    protected ResultsUploader(PrintWriter stdout, Gson gson, UploadHandler handler, ResultProcessorConfig resultProcessorConfig) throws InvalidConfigurationException {
        this.stdout = stdout;
        this.handler = handler;
        this.gson = gson;
        String apiKeyString = (String)resultProcessorConfig.options().get((Object)"key");
        Optional apiKey = Optional.absent();
        if (Strings.isNullOrEmpty((String)apiKeyString)) {
            logger.info("No api key specified. Uploading results anonymously.");
        } else {
            try {
                apiKey = Optional.of((Object)UUID.fromString(apiKeyString));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException(String.format("The specified API key (%s) is not valid. API keys are UUIDs and should look like %s.", apiKeyString, new UUID(0L, 0L)), e);
            }
        }
        this.apiKey = apiKey;
        String urlString = (String)resultProcessorConfig.options().get((Object)"url");
        if (Strings.isNullOrEmpty((String)urlString)) {
            logger.info("No upload URL was specified. Results will not be uploaded.");
            this.uploadUri = Optional.absent();
        } else {
            try {
                this.uploadUri = Optional.of((Object)new URI(urlString).resolve(POST_PATH));
            }
            catch (URISyntaxException e) {
                throw new InvalidConfigurationException(String.valueOf(urlString).concat(" is an invalid upload url"), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processTrial(Trial trial) {
        block3: {
            if (!this.uploadUri.isPresent()) break block3;
            boolean succeeded = false;
            try {
                String json = this.gson.toJson((Object)ImmutableList.of((Object)trial));
                succeeded = this.handler.upload((URI)this.uploadUri.get(), json, MediaType.JSON_UTF_8.toString(), this.apiKey, trial);
                this.failure |= !succeeded;
            }
            catch (Throwable throwable) {
                this.failure |= !succeeded;
                throw throwable;
            }
            if (succeeded) {
                this.runId = Optional.of((Object)trial.run().id());
            }
        }
    }

    static void logUploadFailure(Trial trial) {
        logger.log(Level.SEVERE, String.format("Could not upload trial %s. Consider uploading it manually.", trial.id()));
    }

    static void logUploadFailure(Trial trial, Exception e) {
        logger.log(Level.SEVERE, String.format("Could not upload trial %s. Consider uploading it manually.", trial.id()), e);
    }

    public final void close() {
        if (this.uploadUri.isPresent()) {
            if (this.runId.isPresent()) {
                this.stdout.printf("Results have been uploaded. View them at: %s%n", ((URI)this.uploadUri.get()).resolve(String.format(RESULTS_PATH_PATTERN, this.runId.get())));
            }
            if (this.failure) {
                this.stdout.println("Some trials failed to upload. Consider uploading them manually.");
            }
        } else {
            logger.fine("No upload URL was provided, so results were not uploaded.");
        }
    }

    public static interface UploadHandler {
        public boolean upload(URI var1, String var2, String var3, Optional<UUID> var4, Trial var5);
    }
}

