/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.config.DeviceConfig;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.target.AndroidVm;
import com.google.caliper.runner.target.Jvm;
import com.google.caliper.runner.target.ShutdownHookRegistrar;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.target.Vm;
import com.google.caliper.runner.target.VmProcess;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;

public abstract class Device
extends AbstractIdleService {
    private final DeviceConfig config;
    private final ShutdownHookRegistrar shutdownHookRegistrar;

    protected Device(DeviceConfig config, ShutdownHookRegistrar shutdownHookRegistrar) {
        this.config = (DeviceConfig)Preconditions.checkNotNull((Object)config);
        this.shutdownHookRegistrar = (ShutdownHookRegistrar)Preconditions.checkNotNull((Object)shutdownHookRegistrar);
    }

    public final DeviceConfig config() {
        return this.config;
    }

    public final String name() {
        return this.config.name();
    }

    public final Target createDefaultTarget() {
        return this.createTarget(this.defaultVmConfig());
    }

    public final Target createTarget(VmConfig vmConfig) {
        return Target.create(this, this.createVm(vmConfig));
    }

    private Vm createVm(VmConfig vmConfig) {
        VmType type = (VmType)((Object)vmConfig.type().or((Object)this.defaultVmType()));
        String classpath = this.workerClasspath(type);
        switch (type) {
            case JVM: {
                return Jvm.create(vmConfig, classpath);
            }
            case ANDROID: {
                return AndroidVm.create(vmConfig, classpath, (String)this.workerNativeLibraryDir(type).get());
            }
        }
        throw new AssertionError((Object)type);
    }

    public abstract String vmExecutablePath(Vm var1);

    public abstract String workerClasspath(VmType var1);

    public abstract Optional<String> workerNativeLibraryDir(VmType var1);

    public abstract VmType defaultVmType();

    public abstract VmConfig defaultVmConfig();

    public final VmProcess startVm(VmProcess.Spec spec, VmProcess.Logger logger) throws Exception {
        final VmProcess process = this.doStartVm(spec, logger);
        String string = String.valueOf(spec.id());
        final Thread shutdownHook = new Thread(this, new StringBuilder(21 + String.valueOf(string).length()).append("worker-shutdown-hook-").append(string).toString()){

            @Override
            public void run() {
                process.kill();
            }
        };
        process.addStopListener(new VmProcess.StopListener(){

            @Override
            public void stopped(VmProcess process) {
                Device.this.shutdownHookRegistrar.removeShutdownHook(shutdownHook);
            }
        });
        this.shutdownHookRegistrar.addShutdownHook(shutdownHook);
        return process;
    }

    protected abstract VmProcess doStartVm(VmProcess.Spec var1, VmProcess.Logger var2) throws Exception;

    public String toString() {
        return this.name();
    }
}

