/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker;

import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.target.VmProcess;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.UUID;

public abstract class WorkerSpec
implements VmProcess.Spec {
    private final Target target;
    private final UUID id;
    private final ImmutableList<String> args;

    protected WorkerSpec(Target target, UUID id, Object ... args) {
        this(target, id, (Iterable<String>)FluentIterable.from((Object[])args).transform(Functions.toStringFunction()));
    }

    protected WorkerSpec(Target target, UUID id, Iterable<String> args) {
        this.target = (Target)Preconditions.checkNotNull((Object)target);
        this.id = (UUID)Preconditions.checkNotNull((Object)id);
        this.args = ImmutableList.copyOf(args);
    }

    @Override
    public final UUID id() {
        return this.id;
    }

    public String name() {
        String string = String.valueOf(this.id);
        return new StringBuilder(7 + String.valueOf(string).length()).append("worker-").append(string).toString();
    }

    @Override
    public final Target target() {
        return this.target;
    }

    @Override
    public final ImmutableList<String> vmOptions() {
        return this.target.vm().args(new Iterable[]{this.additionalVmOptions()});
    }

    protected ImmutableList<String> additionalVmOptions() {
        return ImmutableList.of();
    }

    @Override
    public String mainClass() {
        return "com.google.caliper.worker.WorkerMain";
    }

    @Override
    public final ImmutableList<String> mainArgs() {
        return this.args;
    }

    public abstract WorkerRequest request();

    public void printInfoHeader(PrintWriter writer) {
    }
}

