/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.targetinfo;

import com.google.caliper.bridge.TargetInfoLogMessage;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.core.UserCodeException;
import com.google.caliper.model.Host;
import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.worker.ProxyWorkerException;
import com.google.caliper.runner.worker.targetinfo.TargetInfo;
import com.google.caliper.runner.worker.targetinfo.TargetInfoComponent;
import com.google.caliper.runner.worker.targetinfo.TargetInfoFactory;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public final class TargetInfoFromWorkerFactory
implements TargetInfoFactory {
    private final ImmutableSet<Target> targets;
    private final Provider<TargetInfoComponent.Builder> targetInfoComponentBuilder;

    @Inject
    TargetInfoFromWorkerFactory(ImmutableSet<Target> targets, Provider<TargetInfoComponent.Builder> targetInfoComponentBuilder) {
        this.targets = targets;
        this.targetInfoComponentBuilder = targetInfoComponentBuilder;
    }

    @Override
    public TargetInfo getTargetInfo() {
        HashMultimap models = HashMultimap.create();
        HashMap<Target, Host> hosts = new HashMap<Target, Host>();
        try {
            for (Target target : this.targets) {
                TargetInfoLogMessage logMessage = ((TargetInfoComponent.Builder)this.targetInfoComponentBuilder.get()).target(target).build().workerRunner().runWorker();
                models.put((Object)logMessage.model(), (Object)target);
                hosts.put(target, new Host.Builder().addAllProperties((Map)logMessage.deviceProperties()).build());
            }
        }
        catch (ProxyWorkerException e) {
            if (e.exceptionType().equals(UserCodeException.class.getName())) {
                throw new UserCodeException(e.message(), (Throwable)e);
            }
            if (e.exceptionType().equals(InvalidBenchmarkException.class.getName())) {
                throw new InvalidBenchmarkException(e.message(), (Throwable)e);
            }
            throw e;
        }
        if (models.keySet().size() > 1) {
            throw new InvalidConfigurationException("Different targets produced different models of the benchmark class. Please ensure that the classpaths used for each type of target contain equivalent versions of the benchmark class.");
        }
        return TargetInfo.create((BenchmarkClassModel)Iterables.getOnlyElement((Iterable)models.keySet()), hosts);
    }
}

