/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.bridge;

import com.google.caliper.bridge.WorkerRequest;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class CommandLineSerializer {
    private CommandLineSerializer() {
    }

    public static String render(WorkerRequest message) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(message);
            out.close();
            return BaseEncoding.base64().encode(bytes.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static WorkerRequest parse(String arg) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(BaseEncoding.base64().decode((CharSequence)arg));
            ObjectInputStream in = new ObjectInputStream(bais);
            WorkerRequest instance = (WorkerRequest)in.readObject();
            in.close();
            Preconditions.checkState((bais.read() == -1 ? 1 : 0) != 0, (String)"Message %s contains more than one object.", (Object)arg);
            return instance;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot decode message", e);
        }
    }
}

