/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.core;

import com.google.auto.value.AutoValue;
import com.google.caliper.Param;
import com.google.caliper.api.VmOptions;
import com.google.caliper.core.AutoValue_BenchmarkClassModel;
import com.google.caliper.core.AutoValue_BenchmarkClassModel_MethodModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.core.Parameters;
import com.google.caliper.util.InvalidCommandException;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.Set;

@AutoValue
public abstract class BenchmarkClassModel
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static BenchmarkClassModel create(Class<?> clazz) {
        if (!clazz.getSuperclass().equals(Object.class)) {
            throw new InvalidBenchmarkException("Class '%s' must not extend any class other than %s. Prefer composition.", clazz, Object.class);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new InvalidBenchmarkException("Class '%s' is abstract", clazz);
        }
        Builder builder = new AutoValue_BenchmarkClassModel.Builder().setName(clazz.getName()).setSimpleName(clazz.getSimpleName());
        for (Method method : clazz.getDeclaredMethods()) {
            builder.methodsBuilder().add((Object)MethodModel.of(method));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(Param.class)) continue;
            builder.parametersBuilder().put((Object)((Field)accessibleObject).getName(), Parameters.validateAndGetDefaults((Field)accessibleObject));
        }
        VmOptions vmOptions = clazz.getAnnotation(VmOptions.class);
        if (vmOptions != null) {
            builder.vmOptionsBuilder().add((Object[])vmOptions.value());
        }
        return builder.build();
    }

    public static void validateUserParameters(Class<?> clazz, SetMultimap<String, String> userParameters) {
        for (String paramName : userParameters.keySet()) {
            try {
                Field field = clazz.getDeclaredField(paramName);
                Parameters.validate(field, userParameters.get((Object)paramName));
            }
            catch (NoSuchFieldException e) {
                String string = String.valueOf(paramName);
                throw new InvalidCommandException(string.length() != 0 ? "unrecognized parameter: ".concat(string) : new String("unrecognized parameter: "), new Object[0]);
            }
            catch (InvalidBenchmarkException e) {
                throw new InvalidCommandException(e.getMessage(), new Object[0]);
            }
        }
    }

    public abstract String name();

    public abstract String simpleName();

    public abstract ImmutableSet<MethodModel> methods();

    abstract ImmutableMap<String, ImmutableSet<String>> parameters();

    public final ImmutableSetMultimap<String, String> fillInDefaultParameterValues(ImmutableSetMultimap<String, String> userParameters) {
        ImmutableSetMultimap.Builder combined = ImmutableSetMultimap.builder();
        for (String name : Sets.union((Set)this.parameters().keySet(), (Set)userParameters.keySet())) {
            ImmutableSet values = userParameters.containsKey((Object)name) ? userParameters.get((Object)name) : (ImmutableSet)this.parameters().get((Object)name);
            combined.putAll((Object)name, (Iterable)values);
            Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (String)"ERROR: No default value provided for %s", (Object)name);
        }
        return combined.orderKeysBy((Comparator)Ordering.natural()).build();
    }

    public abstract ImmutableSet<String> vmOptions();

    public String toString() {
        return this.name();
    }

    @AutoValue
    public static abstract class MethodModel
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static MethodModel of(Method method) {
            Builder builder = new AutoValue_BenchmarkClassModel_MethodModel.Builder().setName(method.getName()).setModifiers(method.getModifiers()).setDeclaringClass(method.getDeclaringClass().getName());
            if (!method.getReturnType().equals(Void.TYPE)) {
                builder.setReturnType(method.getReturnType().getName());
            }
            for (Class<?> parameterType : method.getParameterTypes()) {
                builder.parameterTypesBuilder().add((Object)parameterType.getName());
            }
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                builder.exceptionTypesBuilder().add((Object)exceptionType.getName());
            }
            for (Annotation annotation : method.getAnnotations()) {
                builder.annotationTypesBuilder().add((Object)annotation.annotationType().getName());
            }
            return builder.build();
        }

        public abstract String name();

        public abstract int modifiers();

        public abstract String declaringClass();

        public abstract Optional<String> returnType();

        public abstract ImmutableList<String> parameterTypes();

        public abstract ImmutableSet<String> exceptionTypes();

        public abstract ImmutableSet<String> annotationTypes();

        public final boolean isAnnotationPresent(String annotationTypeName) {
            Preconditions.checkNotNull((Object)annotationTypeName);
            return this.annotationTypes().contains((Object)annotationTypeName);
        }

        public final boolean isAnnotationPresent(Class<?> annotationType) {
            return this.isAnnotationPresent(annotationType.getName());
        }

        @AutoValue.Builder
        static interface Builder {
            public Builder setName(String var1);

            public Builder setModifiers(int var1);

            public Builder setDeclaringClass(String var1);

            public Builder setReturnType(String var1);

            public ImmutableList.Builder<String> parameterTypesBuilder();

            public ImmutableSet.Builder<String> exceptionTypesBuilder();

            public ImmutableSet.Builder<String> annotationTypesBuilder();

            public MethodModel build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setName(String var1);

        abstract Builder setSimpleName(String var1);

        abstract ImmutableSet.Builder<MethodModel> methodsBuilder();

        public abstract ImmutableMap.Builder<String, ImmutableSet<String>> parametersBuilder();

        public abstract Builder setVmOptions(Iterable<String> var1);

        public abstract ImmutableSet.Builder<String> vmOptionsBuilder();

        public abstract BenchmarkClassModel build();
    }
}

