/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.memory;

import com.google.caliper.memory.Chain;
import com.google.caliper.memory.ObjectVisitor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Unsafe;

public final class ObjectExplorer {
    static final Predicate<Chain> notEnumFieldsOrClasses = new Predicate<Chain>(){

        public boolean apply(Chain chain) {
            return !Enum.class.isAssignableFrom(chain.getValueType()) && !(chain.getValue() instanceof Class);
        }
    };
    static final Function<Chain, Object> chainToObject = new Function<Chain, Object>(){

        public Object apply(Chain chain) {
            return chain.getValue();
        }
    };
    private static final ConcurrentHashMap<Class<?>, Field[]> clazzFields = new ConcurrentHashMap();
    private static final Unsafe UNSAFE;

    private ObjectExplorer() {
    }

    public static <T> T exploreObject(Object rootObject, ObjectVisitor<T> visitor) {
        return ObjectExplorer.exploreObject(rootObject, visitor, EnumSet.noneOf(Feature.class));
    }

    public static <T> T exploreObject(Object rootObject, ObjectVisitor<T> visitor, EnumSet<Feature> features) {
        ArrayDeque<Chain> stack = new ArrayDeque<Chain>(32);
        if (rootObject != null) {
            stack.push(Chain.root(rootObject));
        }
        block6: while (!stack.isEmpty()) {
            Chain chain = (Chain)stack.pop();
            ObjectVisitor.Traversal traversal = visitor.visit(chain);
            switch (traversal) {
                case SKIP: {
                    continue block6;
                }
                case EXPLORE: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Object value = chain.getValue();
            Class<?> valueClass = value.getClass();
            if (valueClass.isArray()) {
                boolean isPrimitive = valueClass.getComponentType().isPrimitive();
                for (int i = Array.getLength(value) - 1; i >= 0; --i) {
                    Object childValue = Array.get(value, i);
                    if (isPrimitive) {
                        if (!features.contains((Object)Feature.VISIT_PRIMITIVES)) continue;
                        visitor.visit(chain.appendArrayIndex(i, childValue));
                        continue;
                    }
                    if (childValue == null) {
                        if (!features.contains((Object)Feature.VISIT_NULL)) continue;
                        visitor.visit(chain.appendArrayIndex(i, childValue));
                        continue;
                    }
                    stack.push(chain.appendArrayIndex(i, childValue));
                }
                continue;
            }
            Field[] fields = ObjectExplorer.getAllFields(value);
            for (int j = fields.length - 1; j >= 0; --j) {
                Field field = fields[j];
                if (field.getDeclaringClass().equals(Reference.class) && !field.getName().equals("referent")) continue;
                Object childValue = null;
                try {
                    childValue = ObjectExplorer.fieldGetHelper(value, field);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                if (childValue == null) {
                    if (!features.contains((Object)Feature.VISIT_NULL)) continue;
                    visitor.visit(chain.appendField(field, childValue));
                    continue;
                }
                boolean isPrimitive = field.getType().isPrimitive();
                Chain.FieldChain extendedChain = chain.appendField(field, childValue);
                if (isPrimitive) {
                    if (!features.contains((Object)Feature.VISIT_PRIMITIVES)) continue;
                    visitor.visit(extendedChain);
                    continue;
                }
                stack.push(extendedChain);
            }
        }
        return visitor.result();
    }

    private static Field[] getAllFields(Object o) {
        Class<?> clazz = o.getClass();
        return ObjectExplorer.getAllFields(clazz);
    }

    private static Field[] getAllFields(Class<?> clazz) {
        Field[] f = clazzFields.get(clazz);
        if (f == null) {
            f = ObjectExplorer.computeAllFields(clazz);
            Field[] u = clazzFields.putIfAbsent(clazz, f);
            return u == null ? f : u;
        }
        return f;
    }

    private static Field[] computeAllFields(Class<?> clazz) {
        ArrayList fields = Lists.newArrayListWithCapacity((int)8);
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    private static Object fieldGetHelper(Object obj, Field field) {
        long fieldOffset;
        Object fieldBase;
        if ((field.getModifiers() & 8) == 0) {
            fieldBase = obj;
            fieldOffset = UNSAFE.objectFieldOffset(field);
        } else {
            fieldBase = UNSAFE.staticFieldBase(field);
            fieldOffset = UNSAFE.staticFieldOffset(field);
        }
        Class<?> type = field.getType();
        if (!type.isPrimitive()) {
            return UNSAFE.getObject(fieldBase, fieldOffset);
        }
        if (type.equals(Integer.TYPE)) {
            return UNSAFE.getInt(fieldBase, fieldOffset);
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(UNSAFE.getFloat(fieldBase, fieldOffset));
        }
        if (type.equals(Long.TYPE)) {
            return UNSAFE.getLong(fieldBase, fieldOffset);
        }
        if (type.equals(Byte.TYPE)) {
            return UNSAFE.getByte(fieldBase, fieldOffset);
        }
        if (type.equals(Boolean.TYPE)) {
            return UNSAFE.getBoolean(fieldBase, fieldOffset);
        }
        if (type.equals(Double.TYPE)) {
            return UNSAFE.getDouble(fieldBase, fieldOffset);
        }
        if (type.equals(Short.TYPE)) {
            return UNSAFE.getShort(fieldBase, fieldOffset);
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf(UNSAFE.getChar(fieldBase, fieldOffset));
        }
        String string = String.valueOf(type);
        throw new IllegalStateException(new StringBuilder(14 + String.valueOf(string).length()).append("Unknown class ").append(string).toString());
    }

    static {
        Unsafe unsafe = null;
        try {
            unsafe = Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize Unsafe", e.getCause());
            }
        }
        UNSAFE = unsafe;
    }

    public static enum Feature {
        VISIT_NULL,
        VISIT_PRIMITIVES;

    }

    static class AtMostOncePredicate
    implements Predicate<Chain> {
        private final Set<Object> seen = Collections.newSetFromMap(new IdentityHashMap());

        AtMostOncePredicate() {
        }

        public boolean apply(Chain chain) {
            return this.seen.add(chain.getValue());
        }
    }
}

