/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.Defaults;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.joda.time.Instant;

public final class Run {
    static final Run DEFAULT = new Run();
    private UUID id;
    private String label;
    private Instant startTime;

    private Run() {
        this.id = Defaults.UUID;
        this.label = "";
        this.startTime = Defaults.INSTANT;
    }

    private Run(Builder builder) {
        this.id = builder.id;
        this.label = builder.label;
        this.startTime = builder.startTime;
    }

    public UUID id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Run) {
            Run that = (Run)obj;
            return this.id.equals(that.id) && this.label.equals(that.label) && this.startTime.equals((Object)that.startTime);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.label, this.startTime});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("label", (Object)this.label).add("startTime", (Object)this.startTime).toString();
    }

    public static final class Builder {
        private UUID id;
        private String label = "";
        private Instant startTime;

        public Builder(UUID id) {
            this.id = (UUID)Preconditions.checkNotNull((Object)id);
        }

        public Builder label(String label) {
            this.label = (String)Preconditions.checkNotNull((Object)label);
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = (Instant)Preconditions.checkNotNull((Object)startTime);
            return this;
        }

        public Run build() {
            Preconditions.checkState((this.id != null ? 1 : 0) != 0);
            Preconditions.checkState((this.startTime != null ? 1 : 0) != 0);
            return new Run(this);
        }
    }
}

