/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeMirror;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Do not refer to the autogenerated AutoValue_ class outside the file containing the corresponding @AutoValue base class.", explanation="@AutoValue-annotated classes may form part of your API, but the AutoValue_ generated classes should not. The fact that the generated classes are visible to other classes within the same package is an implementation detail, and is best avoided. Ideally, any reference to the AutoValue_-prefixed class should be confined to a single factory method, with other factories delegating to it if necessary.")
public final class AutoValueSubclassLeaked
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Pattern AUTO_VALUE_PREFIX = Pattern.compile("\\$*AutoValue_.*");
    private static final String AUTO_VALUE_ANNOTATION = "com.google.auto.value.AutoValue";

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableSet<Type> autoValueClassesFromThisFile = AutoValueSubclassLeaked.findAutoValueClasses(tree, state);
        this.scanAndReportAutoValueReferences(tree, autoValueClassesFromThisFile, state);
        return Description.NO_MATCH;
    }

    private void scanAndReportAutoValueReferences(CompilationUnitTree tree, final ImmutableSet<Type> autoValueClassesFromThisFile, VisitorState state) {
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ AutoValueSubclassLeaked this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitClass(ClassTree classTree, Void unused) {
                if (!ASTHelpers.getGeneratedBy((Symbol)ASTHelpers.getSymbol((ClassTree)classTree), (VisitorState)this.state).isEmpty()) {
                    return null;
                }
                return (Void)super.visitClass(classTree, null);
            }

            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                this.handle(memberSelectTree);
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                this.handle(identifierTree);
                return (Void)super.visitIdentifier(identifierTree, null);
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol instanceof Symbol.ClassSymbol && AUTO_VALUE_PREFIX.matcher(symbol.getSimpleName().toString()).matches() && autoValueClassesFromThisFile.stream().noneMatch(av -> ASTHelpers.isSubtype((Type)symbol.type, (Type)av, (VisitorState)this.state))) {
                    this.state.reportMatch(this.this$0.describeMatch(tree));
                }
            }
        }.scan((Tree)tree, null);
    }

    private static ImmutableSet<Type> findAutoValueClasses(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableSet.Builder types = ImmutableSet.builder();
        tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                Symbol.ClassSymbol classSymbol;
                if (ASTHelpers.hasAnnotation((Tree)classTree, (String)AutoValueSubclassLeaked.AUTO_VALUE_ANNOTATION, (VisitorState)state)) {
                    types.add((Object)ASTHelpers.getType((ClassTree)classTree));
                }
                if (AUTO_VALUE_PREFIX.matcher((classSymbol = ASTHelpers.getSymbol((ClassTree)classTree)).getSimpleName().toString()).matches()) {
                    TypeMirror type = classSymbol.asType();
                    while (!((Type)type).hasTag(TypeTag.NONE)) {
                        if (ASTHelpers.hasAnnotation((Symbol)((Type)type).asElement(), (String)AutoValueSubclassLeaked.AUTO_VALUE_ANNOTATION, (VisitorState)state)) {
                            types.add((Object)type);
                            break;
                        }
                        type = state.getTypes().supertype((Type)type);
                    }
                }
                return (Void)super.visitClass(classTree, null);
            }
        }, null);
        return types.build();
    }
}

