/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Calling getClass() on an enum may return a subclass of the enum type", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class GetClassOnEnum
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ENUM_CLASS = MethodMatchers.instanceMethod().onDescendantOf(Enum.class.getName()).named("getClass").withNoParameters();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (ENUM_CLASS.matches((Tree)tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), (int)state.getEndPosition((Tree)tree), (String)".getDeclaringClass()"));
        }
        return Description.NO_MATCH;
    }
}

