/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Objects;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Always pass 'false' to 'Future.cancel()', unless you are propagating a cancellation-with-interrupt from another caller", severity=BugPattern.SeverityLevel.WARNING)
public class Interruption
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CANCEL = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"java.util.concurrent.Future", "com.google.common.util.concurrent.ClosingFuture"}).named("cancel").withParameters("boolean", new String[0]);
    private static final Matcher<MethodInvocationTree> INTERRUPT_OTHER_THREAD = Matchers.allOf((Matcher[])new Matcher[]{Matchers.toType(MethodInvocationTree.class, (Matcher)MethodMatchers.instanceMethod().onDescendantOf("java.lang.Thread").named("interrupt").withNoParameters()), Matchers.not((Matcher)Matchers.receiverOfInvocation((Matcher)MethodMatchers.staticMethod().onDescendantOf("java.lang.Thread").named("currentThread").withNoParameters()))});
    private static final Matcher<ExpressionTree> WAS_INTERRUPTED = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.util.concurrent.AbstractFuture").named("wasInterrupted").withNoParameters();
    private static final Supplier<Symbol> JAVA_UTIL_CONCURRENT_FUTURE = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString("java.util.concurrent.Future"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (INTERRUPT_OTHER_THREAD.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("Thread.interrupt should not be called, except to record the interrupt status on the current thread when dealing with InterruptedException").build();
        }
        if (!CANCEL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (Objects.equals(ASTHelpers.constValue((Tree)argument, Boolean.class), Boolean.FALSE)) {
            return Description.NO_MATCH;
        }
        if (WAS_INTERRUPTED.matches((Tree)argument, state)) {
            return Description.NO_MATCH;
        }
        if (this.delegatingCancelMethod(state, argument)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)argument, (String)"false"));
    }

    private boolean delegatingCancelMethod(VisitorState state, ExpressionTree argument) {
        Symbol sym = ASTHelpers.getSymbol((Tree)argument);
        if (sym == null) {
            return false;
        }
        if (!sym.getKind().equals((Object)ElementKind.PARAMETER)) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)sym.owner;
        if (((List)methodSymbol.getParameters()).size() != 1 || !((Name)methodSymbol.getSimpleName()).contentEquals("cancel")) {
            return false;
        }
        Symbol.ClassSymbol classSymbol = ASTHelpers.enclosingClass((Symbol)methodSymbol);
        return classSymbol.isSubClass((Symbol)JAVA_UTIL_CONCURRENT_FUTURE.get(state), state.getTypes());
    }
}

