/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AutoValue_StronglyType;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

@AutoValue
public abstract class StronglyType {
    abstract Function<String, String> renameFunction();

    abstract ImmutableSet<Type> primitiveTypesToReplace();

    abstract Matcher<ExpressionTree> factoryMatcher();

    abstract BugChecker bugChecker();

    public static Builder forCheck(BugChecker bugChecker) {
        return new AutoValue_StronglyType.Builder().setBugChecker(bugChecker).setRenameFunction(name -> name);
    }

    public final Description match(CompilationUnitTree tree, final VisitorState state) {
        final HashMap<Symbol.VarSymbol, TreePath> fields = new HashMap<Symbol.VarSymbol, TreePath>((Map<Symbol.VarSymbol, TreePath>)this.findPathToPotentialFields(state, (Set<Type>)this.primitiveTypesToReplace()));
        HashMultimap usages = HashMultimap.create();
        new TreePathScanner<Void, Void>(this, (SetMultimap)usages){
            final /* synthetic */ SetMultimap val$usages;
            final /* synthetic */ StronglyType this$0;
            {
                this.val$usages = setMultimap;
                this.this$0 = this$0;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                this.handle(memberSelectTree);
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                this.handle(identifierTree);
                return null;
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (!fields.containsKey(symbol)) {
                    return;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (!(parent instanceof ExpressionTree) || !this.this$0.factoryMatcher().matches((Tree)((ExpressionTree)parent), state)) {
                    fields.remove(symbol);
                    return;
                }
                this.val$usages.put((Object)((Symbol.VarSymbol)symbol), (Object)((ExpressionTree)parent));
            }
        }.scan(tree, null);
        for (Map.Entry entry : fields.entrySet()) {
            state.reportMatch(this.match((TreePath)entry.getValue(), (Symbol.VarSymbol)entry.getKey(), usages.get((Object)((Symbol.VarSymbol)entry.getKey())), state));
        }
        return Description.NO_MATCH;
    }

    private Description match(TreePath variableTreePath, Symbol.VarSymbol replacedSymbol, Set<ExpressionTree> invocationTrees, VisitorState state) {
        if (invocationTrees.stream().map(ASTHelpers::getSymbol).distinct().count() != 1L) {
            return Description.NO_MATCH;
        }
        VariableTree variableTree = (VariableTree)variableTreePath.getLeaf();
        ExpressionTree factory = invocationTrees.iterator().next();
        String newName = this.renameFunction().apply(variableTree.getName().toString());
        SuggestedFix.Builder fix = SuggestedFix.builder();
        Type targetType = ASTHelpers.getType((Tree)factory);
        String typeName = SuggestedFixes.qualifyType((VisitorState)state.withPath(variableTreePath), (SuggestedFix.Builder)fix, (TypeMirror)targetType);
        fix.replace((Tree)variableTree, String.format("%s %s %s = %s(%s);", state.getSourceForNode((Tree)variableTree.getModifiers()), typeName, newName, StronglyType.getMethodSelectOrNewClass(factory, state), StronglyType.getWeakTypeIntitializerCode(variableTree, state)));
        for (ExpressionTree expressionTree : invocationTrees) {
            fix.replace((Tree)expressionTree, newName);
        }
        Type replacedType = state.getTypes().unboxedTypeOrType(replacedSymbol.type);
        return this.bugChecker().buildDescription((Tree)variableTree).setMessage(String.format("This %s is only used to construct %s instances. It would be clearer to strongly type the field instead.", StronglyType.buildStringForType(replacedType, state), targetType.tsym.getSimpleName())).addFix((Fix)fix.build()).build();
    }

    private static String buildStringForType(Type type, VisitorState state) {
        return SuggestedFixes.prettyType((Type)type, (VisitorState)state);
    }

    private static String getWeakTypeIntitializerCode(VariableTree weakType, VisitorState state) {
        String prefix = weakType.getInitializer().getKind() == Tree.Kind.NEW_ARRAY && ((NewArrayTree)weakType.getInitializer()).getType() == null ? String.format("new %s ", state.getSourceForNode(weakType.getType())) : "";
        return prefix + state.getSourceForNode((Tree)weakType.getInitializer());
    }

    private static String getMethodSelectOrNewClass(ExpressionTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                return state.getSourceForNode((Tree)((MethodInvocationTree)tree).getMethodSelect());
            }
            case NEW_CLASS: {
                return "new " + state.getSourceForNode((Tree)((NewClassTree)tree).getIdentifier());
            }
        }
        throw new AssertionError();
    }

    private ImmutableMap<Symbol.VarSymbol, TreePath> findPathToPotentialFields(VisitorState state, final Set<Type> potentialTypes) {
        final ImmutableMap.Builder fields = ImmutableMap.builder();
        BugChecker bugChecker = this.bugChecker();
        Objects.requireNonNull(bugChecker);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, bugChecker, state){
            final /* synthetic */ StronglyType this$0;
            {
                this.this$0 = this$0;
                BugChecker bugChecker = x0;
                Objects.requireNonNull(bugChecker);
                super(bugChecker, state);
            }

            public Void visitVariable(VariableTree variableTree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
                Type type = this.state.getTypes().unboxedTypeOrType(symbol.type);
                if (symbol.getKind() == ElementKind.FIELD && ASTHelpers.canBeRemoved((Symbol.VarSymbol)symbol) && ASTHelpers.isConsideredFinal((Symbol)symbol) && variableTree.getInitializer() != null && potentialTypes.stream().anyMatch(potentialType -> ASTHelpers.isSameType((Type)type, (Type)potentialType, (VisitorState)this.state)) && !this.this$0.bugChecker().isSuppressed((Tree)variableTree, this.state)) {
                    fields.put((Object)symbol, (Object)this.getCurrentPath());
                }
                return (Void)super.visitVariable(variableTree, null);
            }
        }.scan((Tree)state.getPath().getCompilationUnit(), null);
        return fields.buildOrThrow();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRenameFunction(Function<String, String> var1);

        public abstract Builder setFactoryMatcher(Matcher<ExpressionTree> var1);

        abstract Builder setBugChecker(BugChecker var1);

        abstract ImmutableSet.Builder<Type> primitiveTypesToReplaceBuilder();

        @CanIgnoreReturnValue
        public final Builder addType(Type type) {
            this.primitiveTypesToReplaceBuilder().add((Object)type);
            return this;
        }

        public abstract StronglyType build();
    }
}

