/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.checkreturnvalue.Api;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.Types;
import java.lang.reflect.Method;

public final class ApiFactory {
    private static final Type.StructuralTypeMapping<Void> ANNOTATION_REMOVER = new Type.StructuralTypeMapping<Void>(){

        @Override
        public Type visitType(Type t, Void unused) {
            return t.baseType();
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void unused) {
            return super.visitClassType((Type.ClassType)ApiFactory.cloneWithoutMetadata(t), (Object)null);
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Void unused) {
            return super.visitArrayType((Type.ArrayType)ApiFactory.cloneWithoutMetadata(t), (Object)null);
        }
    };

    public static Api fromSymbol(Symbol.MethodSymbol symbol, Types types) {
        return Api.internalCreate(symbol.owner.getQualifiedName().toString(), symbol.name.toString(), (ImmutableList<String>)((ImmutableList)symbol.getParameters().stream().map(p -> ApiFactory.fullyErasedAndUnannotatedType(p.type, types)).collect(ImmutableList.toImmutableList())));
    }

    static String fullyErasedAndUnannotatedType(Type type, Types types) {
        Type erasedType = types.erasureRecursive(type);
        Type unannotatedType = (Type)erasedType.accept(ANNOTATION_REMOVER, null);
        return unannotatedType.toString();
    }

    public static Type cloneWithoutMetadata(Type type) {
        try {
            try {
                Method method = Type.class.getMethod("cloneWithMetadata", TypeMetadata.class);
                return (Type)method.invoke((Object)type, TypeMetadata.class.getField("EMPTY").get(null));
            }
            catch (NoSuchMethodException e) {
                Class<?> annotations = Class.forName("com.sun.tools.javac.code.TypeMetadata$Annotations");
                Method method = Type.class.getMethod("dropMetadata", Class.class);
                return (Type)method.invoke((Object)type, annotations);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private ApiFactory() {
    }
}

