/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibility;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.ContainmentMatchers;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.inject.Inject;

@BugPattern(summary="Incompatible type as argument to Object-accepting Java collections method", severity=BugPattern.SeverityLevel.ERROR)
public class CollectionIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private final FixType fixType;
    private final TypeCompatibility typeCompatibility;

    @Inject
    CollectionIncompatibleType(TypeCompatibility typeCompatibility, ErrorProneFlags flags) {
        this.fixType = flags.getEnum("CollectionIncompatibleType:FixType", FixType.class).orElse(FixType.NONE);
        this.typeCompatibility = typeCompatibility;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description match(ExpressionTree tree, VisitorState state) {
        String targetType;
        AbstractCollectionIncompatibleTypeMatcher.MatchResult result = ContainmentMatchers.firstNonNullMatchResult(tree, state);
        if (result == null) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        TypeCompatibility.TypeCompatibilityReport compatibilityReport = this.typeCompatibility.compatibilityOfTypes(result.targetType(), result.sourceType(), state);
        if (compatibilityReport.isCompatible()) {
            return Description.NO_MATCH;
        }
        String sourceType = Signatures.prettyType((Type)result.sourceType());
        if (sourceType.equals(targetType = Signatures.prettyType((Type)result.targetType()))) {
            sourceType = result.sourceType().toString();
            targetType = result.targetType().toString();
        }
        Description.Builder description = this.buildDescription(tree).setMessage(result.message(sourceType, targetType) + compatibilityReport.extraReason());
        switch (this.fixType.ordinal()) {
            case 2: {
                description.addFix((Fix)SuggestedFix.prefixWith((Tree)tree, (String)String.format("/* expected: %s, actual: %s */", ASTHelpers.getUpperBound((Type)result.targetType(), (Types)types), result.sourceType())));
                break;
            }
            case 1: {
                result.buildFix().ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
                break;
            }
            case 3: {
                SuggestedFix.Builder builder = SuggestedFix.builder();
                builder.prefixWith((Tree)result.sourceTree(), String.format("/* expected: %s, actual: %s */ ", targetType, sourceType));
                SuggestedFixes.addSuppressWarnings((SuggestedFix.Builder)builder, (VisitorState)state, (String)"CollectionIncompatibleType");
                description.addFix((Fix)builder.build());
                break;
            }
        }
        return description.build();
    }

    private static enum FixType {
        NONE,
        CAST,
        PRINT_TYPES_AS_COMMENT,
        SUPPRESS_WARNINGS;

    }
}

