/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.common.collect.Lists;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.type.TypeKind;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="Use withCause to associate Exceptions with log statements", severity=BugPattern.SeverityLevel.WARNING)
public class FloggerWithoutCause
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LOG_METHOD = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log");
    private static final Matcher<ExpressionTree> WITH_CAUSE = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("withCause");

    public Description matchMethodInvocation(MethodInvocationTree tree, final VisitorState state) {
        if (!LOG_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Tree exception = FloggerWithoutCause.getExceptionArg(tree, state);
        if (exception == null) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean withCause = new AtomicBoolean(false);
        tree.accept(new TreeScanner<Void, Void>(this){
            final /* synthetic */ FloggerWithoutCause this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (WITH_CAUSE.matches((Tree)tree, state)) {
                    withCause.set(true);
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }
        }, null);
        if (withCause.get()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.postfixWith((Tree)ASTHelpers.getReceiver((ExpressionTree)tree), (String)String.format(".withCause(%s)", state.getSourceForNode(exception))));
    }

    private static @Nullable Tree getExceptionArg(MethodInvocationTree tree, VisitorState state) {
        for (Tree arg : Lists.reverse(tree.getArguments())) {
            try {
                Type argType = ASTHelpers.getType((Tree)arg);
                if (argType == null || argType.getKind() == TypeKind.NULL || !ASTHelpers.isSubtype((Type)argType, (Type)state.getSymtab().throwableType, (VisitorState)state)) continue;
                return arg;
            }
            catch (RuntimeException runtimeException) {
            }
        }
        return null;
    }
}

