/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableChecker;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

@BugPattern(name="ImmutableRefactoring", summary="Refactors uses of the JSR 305 @Immutable to Error Prone's annotation", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ImmutableRefactoring
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private final WellKnownMutability wellKnownMutability;
    private static final String JSR_305_IMMUTABLE = "javax.annotation.concurrent.Immutable";

    @Inject
    ImmutableRefactoring(WellKnownMutability wellKnownMutability) {
        this.wellKnownMutability = wellKnownMutability;
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableChecker immutableChecker = new ImmutableChecker(this.wellKnownMutability, (ImmutableSet<String>)ImmutableSet.of((Object)JSR_305_IMMUTABLE, (Object)Immutable.class.getName()));
        Optional<ImportTree> immutableImport = tree.getImports().stream().filter(i -> {
            Symbol s = ASTHelpers.getSymbol((Tree)i.getQualifiedIdentifier());
            return s != null && s.getQualifiedName().contentEquals(JSR_305_IMMUTABLE);
        }).findFirst();
        if (!immutableImport.isPresent()) {
            return Description.NO_MATCH;
        }
        final HashSet notOk = new HashSet();
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ ImmutableRefactoring this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitClass(ClassTree node, Void unused) {
                boolean violator;
                if (!ASTHelpers.hasAnnotation((Tree)node, (String)ImmutableRefactoring.JSR_305_IMMUTABLE, (VisitorState)state)) {
                    return (Void)super.visitClass(node, null);
                }
                boolean bl = violator = immutableChecker.matchClass(node, VisitorState.createConfiguredForCompilation((Context)state.context, description -> notOk.add(node), (Map)ImmutableMap.of(), (ErrorProneOptions)state.errorProneOptions()).withPath(this.getCurrentPath())) != Description.NO_MATCH;
                if (violator) {
                    notOk.add(node);
                }
                return (Void)super.visitClass(node, null);
            }
        }.scan(state.getPath(), (Void)null);
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder().removeImport(JSR_305_IMMUTABLE).addImport(Immutable.class.getName());
        for (ClassTree classTree : notOk) {
            ASTHelpers.getAnnotationsWithSimpleName(classTree.getModifiers().getAnnotations(), (String)"Immutable").forEach(arg_0 -> ((SuggestedFix.Builder)fixBuilder).delete(arg_0));
            fixBuilder.prefixWith((Tree)classTree, "// This class was annotated with javax.annotation.concurrent.Immutable, but didn't seem to be provably immutable.\n");
        }
        return this.describeMatch(immutableImport.get(), (Fix)fixBuilder.build());
    }
}

