/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.refaster.AutoValue_ULiteral;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class ULiteral
extends UExpression
implements LiteralTree {
    private static final ImmutableBiMap<Tree.Kind, TypeTag> LIT_KIND_TAG = new ImmutableBiMap.Builder().put((Object)Tree.Kind.INT_LITERAL, (Object)TypeTag.INT).put((Object)Tree.Kind.LONG_LITERAL, (Object)TypeTag.LONG).put((Object)Tree.Kind.FLOAT_LITERAL, (Object)TypeTag.FLOAT).put((Object)Tree.Kind.DOUBLE_LITERAL, (Object)TypeTag.DOUBLE).put((Object)Tree.Kind.CHAR_LITERAL, (Object)TypeTag.CHAR).put((Object)Tree.Kind.BOOLEAN_LITERAL, (Object)TypeTag.BOOLEAN).put((Object)Tree.Kind.NULL_LITERAL, (Object)TypeTag.BOT).put((Object)Tree.Kind.STRING_LITERAL, (Object)TypeTag.CLASS).buildOrThrow();

    public static ULiteral nullLit() {
        return ULiteral.create(Tree.Kind.NULL_LITERAL, null);
    }

    public static ULiteral intLit(int value) {
        return ULiteral.create(Tree.Kind.INT_LITERAL, value);
    }

    public static ULiteral longLit(long value) {
        return ULiteral.create(Tree.Kind.LONG_LITERAL, value);
    }

    public static ULiteral floatLit(float value) {
        return ULiteral.create(Tree.Kind.FLOAT_LITERAL, Float.valueOf(value));
    }

    public static ULiteral doubleLit(double value) {
        return ULiteral.create(Tree.Kind.DOUBLE_LITERAL, value);
    }

    public static ULiteral booleanLit(boolean value) {
        return ULiteral.create(Tree.Kind.BOOLEAN_LITERAL, value);
    }

    public static ULiteral charLit(char value) {
        return ULiteral.create(Tree.Kind.CHAR_LITERAL, Character.valueOf(value));
    }

    public static ULiteral stringLit(String value) {
        return ULiteral.create(Tree.Kind.STRING_LITERAL, value);
    }

    public static ULiteral create(Tree.Kind kind, Object value) {
        Preconditions.checkArgument((boolean)LIT_KIND_TAG.containsKey((Object)kind), (String)"%s is not a literal kind", (Object)((Object)kind));
        return new AutoValue_ULiteral(kind, value);
    }

    @Override
    public abstract Tree.Kind getKind();

    @Override
    public abstract @Nullable Object getValue();

    private static boolean integral(@Nullable Object o) {
        return o instanceof Integer || o instanceof Long;
    }

    private static boolean match(@Nullable Object a, @Nullable Object b) {
        if (a instanceof Number && b instanceof Number) {
            return ULiteral.integral(a) && ULiteral.integral(b) ? ((Number)a).longValue() == ((Number)b).longValue() : Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue()) == 0;
        }
        return Objects.equals(a, b);
    }

    @Override
    public Choice<Unifier> visitLiteral(LiteralTree literal, Unifier unifier) {
        return Choice.condition(ULiteral.match(this.getValue(), literal.getValue()), unifier);
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitLiteral(this, data);
    }

    @Override
    public JCTree.JCLiteral inline(Inliner inliner) {
        Object value = this.getValue();
        switch (this.getKind()) {
            case CHAR_LITERAL: {
                value = (int)((Character)value).charValue();
                break;
            }
            case BOOLEAN_LITERAL: {
                value = (Boolean)value != false ? 1 : 0;
                break;
            }
        }
        return inliner.maker().Literal((TypeTag)((Object)LIT_KIND_TAG.get((Object)this.getKind())), value);
    }

    @Override
    public UExpression negate() {
        Preconditions.checkState((this.getKind() == Tree.Kind.BOOLEAN_LITERAL ? 1 : 0) != 0, (Object)"Cannot negate a non-Boolean literal");
        return ULiteral.booleanLit((Boolean)this.getValue() == false);
    }
}

